\name{mst.mle}
\alias{mst.mle}
\alias{st.mle}
\title{
Maximum likelihood estimation for a (multivariate) skew-t distribution
}
\description{
Fits a skew-t (ST) or multivariate skew-t (MST) distribution to data, or 
fits a linear regression model with (multivariate) skew-t errors,
using maximum likelihood estimation.
}
\usage{
mst.mle(X, y, freq, start, fixed.df=NA, trace=FALSE,  method="BFGS", 
       control=list(iter.max=150) )

st.mle(X, y, freq, start, fixed.df=NA, trace=FALSE,  method="BFGS", 
       control=list(iter.max=150) )

}
\arguments{
\item{y}{
a matrix (for \code{mst.mle}) or a vector (for \code{st.mle}).  
If \code{y} is a matrix, rows refer to observations, and columns to 
components of the multivariate distribution. 
}
\item{X}{
  a matrix of covariate values.
  If missing, a one-column matrix of 1's is created; otherwise,
  it must have the same number of rows of \code{y}.
  If \code{X} is supplied, then it must include a column of 1's.
}
\item{freq}{
a vector of weights.
If missing, a one-column matrix of 1's is created; otherwise
it must have the same number of rows of \code{y}.
}
\item{start}{
a list contaning the components \code{beta},\code{Omega}, \code{alpha},
\code{df} of the type described below. The \code{dp} component of the returned
list from a previous call has the required format and it can be used as a new
\code{start}. If missing, initial values are computed fitting an
ordinary linear model and with shape parameter set to 0.

}
\item{fixed.df}{
a scalar value containing the degrees of freedom (df), if these must
be taked as fixed, or \code{NA} (default value) if \code{df} is a parameter
to be estimated.
}
\item{trace}{
logical value which controls printing of the algorithm convergence.
If \code{trace=TRUE}, details are printed. Default value is \code{FALSE}.
}
\item{method}{
this parameter is just passed to the optimizer \code{optim}; 
see the documentation of this function for its usage. Default value is
\code{"BFGS"}.
}
\item{control}{
this parameter is passed to the optimizer \code{optim}; 
see the documentation of this function for its usage.
}}
\value{
A list containing the following components:

\item{call}{
a string containing the calling statement.
}
\item{dp}{
a list containing the direct parameters \code{beta}, \code{Omega}, \code{alpha}.
Here, \code{beta} is a matrix of regression coefficients with
\code{dim(beta)=c(ncol(X),ncol(y))}, \code{Omega} is a covariance matrix of
order \code{ncol(y)}, \code{alpha} is a vector of shape parameters of length
\code{ncol(y)}.
Notice that, if \code{st.mle} was called or equivalently \code{mst.mle}
was called with \code{y} a vector, then \code{Omega} represents the
\emph{square} of the scale parameter. 
}
\item{se}{
a list containing the components \code{beta}, \code{alpha}, \code{info}.
Here, \code{beta} and \code{alpha} are the standard errors for the
corresponding point estimates;
\code{info} is the observed information matrix for the working parameter,
as explained below.
}
\item{optim}{
the list returned by the optimizer \code{optim}; see the documentation
of this function for explanation of its components.
}}
\details{
If \code{y} is a vector and it is supplied to \code{mst.mle}, then
it is converted to a one-column matrix, and a scalar skew-t 
distribution is fitted. This is the mechanism used by \code{st.mle}
which is simply an interface to \code{mst.mle}.

The parameter \code{freq} is intended for use with grouped data,
setting the values of \code{y} equal to the central values of the
cells; in this case the resulting estimate is an approximation
to the exact maximum likelihood estimate. If \code{freq} is not
set, exact maximum likelihood estimation is performed.

% To fit a scalar skew-t distribution to grouped data by exact
% maximum likelihood estimation, use \code{st.mle.grouped}.
}
\section{Background}{
The family of multivariate skew-t distributions is an extension of the 
multivariate Student's t family, via the introduction of a \code{shape} 
parameter which regulates skewness; when \code{shape=0}, the skew-t 
distribution reduces to the usual t distribution. 
When \code{df=Inf} the distribution reduces to the multivariate skew-normal 
one; see \code{dmsn}. See the reference below for additional information.
}
\references{
Azzalini, A. and Capitanio, A. (2003).
  Distributions generated by perturbation of symmetry 
  with emphasis on a multivariate skew \emph{t} distribution.
  \emph{J.Roy. Statist. Soc. B} \bold{65}, 367--389.
}
\seealso{
\code{\link{dmst}},\code{\link{msn.mle}},\code{\link{mst.fit}}, \code{\link{optim}}
% \code{\link{sn.mle.grouped}}
}
\examples{
data(ais, package="sn")
attach(ais)
X.mat <- model.matrix(~lbm+sex)
b <- sn.mle(X.mat, bmi)
# 
b <- mst.mle(y=cbind(Ht,Wt))
#
# a multivariate regression case:
a <- mst.mle(X=cbind(1,Ht,Wt), y=bmi, control=list(x.tol=1e-6))
#
# refine the previous outcome
a1 <- mst.mle(X=cbind(1,Ht,Wt), y=bmi, control=list(x.tol=1e-9), start=a$dp)
}
\keyword{distribution}
\keyword{regression}

