% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_about_one_seed.R
\name{sample_about_one_seed}
\alias{sample_about_one_seed}
\title{Snowball Sampling with Multiple Inclusion Around a Single Seed}
\usage{
sample_about_one_seed(net, seed0, n.neigh = 1)
}
\arguments{
\item{net}{A network object that is list containing:
\describe{
  \item{edges}{The edgelist of the network. A two column
    \code{matrix} where each row is an edge.}
  \item{degree}{The degree sequence of the network, which is
    an \code{integer} vector of length n.}
  \item{n}{The network order.}
}
  The object can be created by \code{\link{local.network.MR.new5}} or
  it can be imported.}

\item{seed0}{\code{num}. Id of a seed to be sampled around.}

\item{n.neigh}{A number of waves to be sampled around each seed in LSMI.
For example, n.neigh = 0 corresponds to seeds only, and n.neigh = 1
corresponds to sampling seeds and their first neighbors).
Note that the algorithm allows for multiple inclusions.}
}
\value{
a list containing:
   \item{seed}{seed0 \code{num}. Id of a seed to be sampled around.}
   \item{sampleN}{A vector of numeric ids of the nodes from
         LSMI along with the original seed. This vector may have
         duplicates, since the algorithm allows for multiple inclusions.}
   \item{unode}{A vector containing the unique values in \code{$sampleN}.}
   \item{nodes.waves}{A list of length \code{n.neigh} containing vectors where
         each vector reports numeric ids of nodes sampled in a particular wave.}
}
\description{
This function performs snowball sampling with multiple inclusions (LSMI) around a
single seed.
}
\note{
\code{\link{LSMI}.}
}
\examples{
net <- artificial_networks[[1]]
a <- sample_about_one_seed(net = net, seed0 = 1, n.neigh = 2)
}
\references{
Thompson, M. E., Ramirez Ramirez, L. L., Lyubchich, V. and
 Gel, Y. R. (2015), Using the bootstrap for statistical inference
 on random graphs. Can J Statistics. doi: 10.1002/cjs.11271
}

