% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpmajority.R
\name{cpMajorityComparison}
\alias{cpMajorityComparison}
\alias{cpMajorityComparisonScore}
\title{CP-Majority relation}
\usage{
cpMajorityComparison(
  powerRelation,
  e1,
  e2,
  strictly = FALSE,
  includeEmptySet = TRUE
)

cpMajorityComparisonScore(
  powerRelation,
  e1,
  e2,
  strictly = FALSE,
  includeEmptySet = TRUE
)
}
\arguments{
\item{powerRelation}{A \code{\link{PowerRelation}} object created by \code{\link[=PowerRelation]{PowerRelation()}} or \code{\link[=as.PowerRelation]{as.PowerRelation()}}}

\item{e1, e2}{Elements in \code{powerRelation$elements}}

\item{strictly}{Only include \eqn{D_{ij}(\succ)}{D_ij(>)} and \eqn{D_{ji}(\succ)}{D_ji(>)}, i.e., coalitions
\eqn{S \in 2^{N \setminus \lbrace i,j\rbrace}}{S in 2^(N-{i,j})} where
\eqn{S \cup \lbrace i\rbrace \succ S \cup \lbrace j\rbrace}{Sui > Suj} and
vice versa.}

\item{includeEmptySet}{If \code{TRUE}, check \eqn{\lbrace i \rbrace \succeq \lbrace j \rbrace}{\{i\} >= \{j\}} even if
empty set is not part of the power relation.}
}
\value{
\code{cpMajorityComparison()} returns a list with elements described in the details.

\code{cpMajorityComparisonScore()} returns a vector of two numbers, a positive number of coalitions where \code{e1} beats \code{e2}
(\eqn{d_{ij}(\succeq)}{d_ij(>=)}), and a negative number of coalitions where \code{e1} is beaten by \code{e2} (\eqn{-d_{ji}(\succeq)}{-d_ji(>=)}).
}
\description{
The Ceteris Paribus-majority relation compares the relative success between two players joining a coalition.

\code{cpMajorityComparisonScore()} only returns two numbers, a positive number of coalitions where \code{e1} beats \code{e2},
and a negative number of coalitions where \code{e1} is beaten by \code{e2}.
}
\details{
Given two elements \eqn{i}{i} and \eqn{j}{j}, go through each coalition \eqn{S \in 2^{N \setminus \lbrace i, j \rbrace}}{S in 2^(N - \{i,j\})}.
\eqn{D_{ij}(\succeq)}{D_ij(>=)} then contains all coalitions \eqn{S}{S} where
\eqn{S \cup \lbrace i \rbrace \succeq S \cup \lbrace j \rbrace}{S u \{i\} >= S u \{j\}} and \eqn{D_{ji}(\succeq)}{D_ji(>=)} contains all coalitions where
\eqn{S \cup \lbrace j \rbrace \succeq S \cup \lbrace i \rbrace}{S u \{j\} >= S u \{i\}}.

The cardinalities
\eqn{d_{ij}(\succeq) = |D_{ij}|}{d_ij(>=) = |D_ij|} and
\eqn{d_{ji}(\succeq) = |D_{ji}|}{d_ij(>=) = |D_ji|} represent the score of the two elements, where
\eqn{i \succ j}{i > j}    if \eqn{d_{ij}(\succeq)   >  d_{ji}(\succeq)}{d_ij(>=) >  d_ji(>=)} and
\eqn{i \sim  j}{i ~ j}    if \eqn{d_{ij}(\succeq)  ==  d_{ji}(\succeq)}{d_ij(>=) == d_ji(>=)}.

\code{\link[=cpMajorityComparison]{cpMajorityComparison()}} tries to retain all that information. The list returned contains the following information.
Note that in this context the two elements \eqn{i}{i} and \eqn{j}{j} refer to element 1 and element 2 respectively.
\itemize{
\item \verb{$e1}: list of information about element 1
\itemize{
\item \verb{$e1$name}: name of element 1
\item \verb{$e1$score}: score \eqn{d_{ij}(\succeq)}{d_ij(>=)}. \eqn{d_{ij}(\succ)}{d_ij(>)} if \code{strictly == TRUE}
\item \verb{$e1$winningCoalitions}: list of coalition \code{\link[base:c]{vectors}} \eqn{S \in D_{ij}(\succeq)}{S in D_ij(>=)}. \eqn{S \in D_{ij}(\succ)}{S in D_ij(>)} if \code{strictly == TRUE}
}
\item \verb{$e2}: list of information about element 2
\itemize{
\item \verb{$e2$name}: name of element 2
\item \verb{$e1$score}: score \eqn{d_{ji}(\succeq)}{d_ji(>=)}. \eqn{d_{ji}(\succ)}{d_ji(>)} if \code{strictly == TRUE}
\item \verb{$e1$winningCoalitions}: list of coalition \code{\link[base:c]{vectors}} \eqn{S \in D_{ji}(\succeq)}{S in D_ji(>=)}.  \eqn{S \in D_{ji}(\succ)}{S in D_ji(>)} if \code{strictly == TRUE}
}
\item \verb{$winner}: name of higher scoring element. \code{NULL} if they are indifferent.
\item \verb{$loser}: name of lower scoring element. \code{NULL} if they are indifferent.
\item \verb{$tuples}: a list of coalitions \eqn{S \in 2^{N \setminus \lbrace i, j \rbrace }}{S in 2^(N - \{i,j\})} with:
\itemize{
\item \verb{$tuples[[x]]$coalition}: \code{\link[base:c]{vector}}, the coalition \eqn{S}{S}
\item \verb{$tuples[[x]]$included}: logical, \code{TRUE} if \eqn{S \cup \lbrace i \rbrace}{Su\{i\}} and \eqn{S \cup \lbrace j \rbrace}{Su\{j\}} are in the power relation
\item \verb{$tuples[[x]]$winner}: name of the winning element \eqn{i}{i} where \eqn{S \cup \lbrace i \rbrace \succ S \cup \lbrace j \rbrace}{S u \{i\} > S u \{j\}}. It is \code{NULL} if \eqn{S \cup \lbrace i \rbrace \sim S \cup \lbrace j \rbrace}{S u \{i\} ~ S u \{j\}}
\item \verb{$tuples[[x]]$e1}: index \eqn{x_1}{x_1} at which \eqn{S \cup \lbrace i \rbrace \in \sum_{x_1}}{S u \{i\} in Sum_(x_1)}
\item \verb{$tuples[[x]]$e2}: index \eqn{x_2}{x_2} at which \eqn{S \cup \lbrace j \rbrace \in \sum_{x_2}}{S u \{j\} in Sum_(x_2)}
}
}

The much more efficient \code{\link[=cpMajorityComparisonScore]{cpMajorityComparisonScore()}} only calculates \verb{$e1$score}.

Unlike Lexcel, Ordinal Banzhaf, etc., this power relation can introduce cycles. For this reason the function
\code{\link[=cpMajorityComparison]{cpMajorityComparison()}} and \code{\link[=cpMajorityComparisonScore]{cpMajorityComparisonScore()}} only offers direct comparisons between two elements
and not a ranking of all players. See the other CP-majority based functions that offer a way to rank all players.
}
\examples{
pr <- as.PowerRelation("ac > (a ~ b) > (c ~ bc)")

scores <- cpMajorityComparison(pr, "a", "b")
scores
# a > b
# D_ab = {c, {}}
# D_ba = {{}}
# Score of a = 2
# Score of b = 1

stopifnot(scores$e1$name == "a")
stopifnot(scores$e2$name == "b")
stopifnot(scores$e1$score == 2)
stopifnot(scores$e2$score == 1)
stopifnot(scores$e1$score == length(scores$e1$winningCoalitions))
stopifnot(scores$e2$score == length(scores$e2$winningCoalitions))

# get tuples with coalitions S in 2^(N - \{i,j\})
emptySetTuple <- Filter(function(x) identical(x$coalition, c()), scores$tuples)[[1]]
playerCTuple  <- Filter(function(x) identical(x$coalition, "c"), scores$tuples)[[1]]

# because {}u{a} ~ {}u{b}, there is no winner
stopifnot(is.null(emptySetTuple$winner))
stopifnot(emptySetTuple$e1 == emptySetTuple$e2)

# because {c}u{a} > {c}u{b}, player "a" gets the score
stopifnot(playerCTuple$winner == "a")
stopifnot(playerCTuple$e1 < playerCTuple$e2)
stopifnot(playerCTuple$e1 == 1L)
stopifnot(playerCTuple$e2 == 3L)

cpMajorityComparisonScore(pr, "a", "b") # c(1,0)
cpMajorityComparisonScore(pr, "b", "a") # c(0,-1)

}
\references{
\insertRef{2018CPMajority}{socialranking}

\insertRef{2018CPMajoritySims}{socialranking}
}
\seealso{
Other CP-majority based functions: 
\code{\link{copelandScores}()},
\code{\link{kramerSimpsonScores}()}
}
\concept{CP-majority based functions}
