\encoding{UTF8}
\name{strong}
\alias{and}
\alias{gdl}
\alias{luk}
\alias{prd}
\alias{strong}
\alias{weak}
\alias{wMAE}
\alias{wMSE}
\alias{wRMAE}
\alias{wRMSE}
\title{And (conjunction) operators}
\usage{
  strong(r, p)

  luk(r, p)

  weak(r, p)

  gdl(r, p)

  prd(r, p)

  and(r, p)

  wMAE(r, p)

  wRMAE(r, p)

  wMSE(r, p)

  wRMSE(r, p)
}
\arguments{
  \item{p}{prediction vector, matrix, or array with numeric
  values in [0, 1], for \code{and} in \{0, 1\}}

  \item{r}{reference vector, matrix, or array with numeric
  values in [0, 1], for \code{and} in \{0, 1\}}
}
\value{
  numeric of the same size as p
}
\description{
  And operators for the soft performance calculation. The
  predefined operators are: \tabular{llllll}{ Name \tab
  Definition \tab \code{\link{dev}}? \tab
  \code{\link{postproc}}?  \tab \code{\link{hard}}? \tab
  Explanation \cr \code{gdl} \tab \code{pmin (r, p)} \tab
  FALSE \tab \tab FALSE \tab the
  \enc{Gödel}{Goedel}-operator (weak conjunction) \cr
  \code{luk} \tab \code{pmax (r + p - 1, 0)} \tab FALSE
  \tab \tab FALSE \tab
  \enc{Łukasiewicz}{Lukasiewicz}-operator (strong
  conjunction) \cr \code{prd} \tab \code{r * p} \tab FALSE
  \tab \tab FALSE \tab product operator \cr \code{and} \tab
  \code{r * p} \tab FALSE \tab \tab TRUE \tab Boolean
  conjunction: accepts only 0 or 1, otherwise yields
  \code{NA} \cr \code{wMAE} \tab \code{r * abs (r - p)}
  \tab TRUE \tab \tab FALSE \tab for weighted mean absolute
  error \cr \code{wRMAE} \tab \code{r * abs (r - p)} \tab
  TRUE \tab sqrt \tab FALSE \tab for weighted root mean
  absolute error (bound for RMSE) \cr##' \code{wMSE} \tab
  \code{r * (r - p)^2} \tab TRUE \tab \tab FALSE \tab for
  weighted mean squared error \cr \code{wRMSE} \tab \code{r
  * (r - p)^2} \tab TRUE \tab sqrt \tab FALSE \tab for root
  weighted mean squared error \cr }
}
\examples{
ops <- c ("luk", "gdl", "prd", "and", "wMAE", "wRMAE", "wMSE", "wRMSE")

## make a nice table


lastline <- function (f){
  body <- deparse (body (get (f))) ## function body
  body <- body [!grepl ("^[ \\t]*[}][ \\t]*$", body)]
  gsub ("^[ \\t]+([^ \\t].*[^ \\t])[ \\t]*$", "\\\\1", tail (body, 1))
}

data.frame (source = sapply (ops, lastline),
            dev = sapply (ops, function (f) dev (get (f))),
            hard = sapply (ops, function (f) hard (get (f))),
            postproc = I (lapply (ops, function (f) postproc (get (f))))
            )

x <- softclassval:::v
x

luk (0.7, 0.8)

## The behaviour of the operators
## op (x, 1)
cbind (x, sapply (c ("luk", "gdl", "prd", "wMAE", "wRMAE", "wMSE", "wRMSE"),
                  function (op, x) get (op) (x, 1), x))

## op (x, 0)
cbind (x, sapply (c ("luk", "gdl", "prd", "wMAE", "wRMAE", "wMSE", "wRMSE"),
                  function (op, x) get (op) (x, 0), x))

## op (x, x)
cbind (x, sapply (c ("luk", "gdl", "prd", "wMAE", "wRMAE", "wMSE", "wRMSE"),
                  function (op, x) get (op) (x, x), x))


## Note that the deviation operators are not commutative
## (due to the weighting by reference)
zapsmall (
cbind (sapply (c ("luk", "gdl", "prd", "wMAE", "wRMAE", "wMSE", "wRMSE"),
                  function (op, x) get (op) (1, x), x)) -
cbind (sapply (c ("luk", "gdl", "prd", "wMAE", "wRMAE", "wMSE", "wRMSE"),
                  function (op, x) get (op) (x, 1), x))
)
}
\author{
  Claudia Beleites
}
\references{
  see the literature in \code{citation ("softclassval")}
}
\seealso{
  Performance measures: \code{\link{sens}}
}

