% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchSDA_spatial.R
\name{fetchSDA_spatial}
\alias{fetchSDA_spatial}
\title{Query SDA and Return Spatial Data}
\usage{
fetchSDA_spatial(
  x,
  by.col = "mukey",
  method = "feature",
  add.fields = NULL,
  chunk.size = 10,
  verbose = TRUE
)
}
\arguments{
\item{x}{A vector of MUKEYs or national mapunit symbols.}

\item{by.col}{Column name containing mapunit identifier ("mukey" or "nmusym"); default: "mukey"}

\item{method}{geometry result type: 'feature' returns polygons, 'bbox' returns the bounding box of each polygon, and 'point' returns a single point within each polygon.}

\item{add.fields}{Column names from `mapunit` table to add to result. Must specify table name prefix `mapunit` before column name (e.g. `mapunit.muname`).}

\item{chunk.size}{How many queries should spatial request be divided into? Necessary for large results. Default: 10}

\item{verbose}{Print messages?}
}
\value{
A Spatial*DataFrame corresponding to SDA spatial data for all MUKEYs / nmusyms requested. Default result contains mapunit delineation geometry with attribute table containing `gid`, `mukey` and `nationalmusym`, plus additional fields in result specified with `add.fields`.
}
\description{
This is a high-level "fetch" method to facilitate spatial queries to Soil Data Access (SDA) based on \code{mukey} or \code{nationalmusym}. 

A SDA spatial query is made returning geometry and key identifying information about the mapunit. Additional columns from the mapunit table can be included using \code{add.fields} argument. 

This function automatically "chunks" the input vector (using \code{soilDB::makeChunks}) of mapunit identifiers to minimize the likelihood of exceeding the SDA data request size. The number of chunks varies with the \code{chunk.size} setting and the length of your input vector. If you are working with many mapunits and/or large extents, you may need to decrease this number in order to have more chunks.

The "sweet-spot" \code{chunk.size} should optimize number of queries relative to the typical amount of information in each query. There is a 100,000 record limit per query and the type / complexity of the geometry affects the total result size; there is a ~32Mb JSON serialization limit.

Querying regions with complex mapping may require smaller \code{chunk.size}. Numerically adjacent IDs in the input vector may share common qualities (say, all from same soil survey area or region) which could cause specific chunks to perform "poorly" [slow or error] no matter what the chunk size is. Shuffling the order of the inputs using \code{sample} may help to eliminate problems related to this, depending on how you obtained your set of MUKEY/nationalmusym to query. One could feasibly use \code{muacres} as a heuristic to adjust for total acreage within chunks.
}
\examples{
\donttest{
if(requireNamespace("curl") &
   curl::has_internet()) {

   # get spatial data for a single mukey
    single.mukey <- fetchSDA_spatial(x = "2924882")
    
    # demonstrate fetching full extent (multi-mukey) of national musym
    full.extent.nmusym <- fetchSDA_spatial(x = "2x8l5", by = "nmusym")
    
    # compare extent of nmusym to single mukey within it
    if(require(sp)) {
     plot(full.extent.nmusym, col = "RED",border=0)
     plot(single.mukey, add = TRUE, col = "BLUE", border=0)
    }
    
    # demo adding a field (`muname`) to attribute table of result
    head(fetchSDA_spatial(x = "2x8l5", by="nmusym", add.fields="muname"))
}
}
}
\author{
Andrew G. Brown
}
