% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plot.lib.R
\name{plotRes}
\alias{plotRes}
\alias{plotResQQ}
\title{Plot the residuals of a polygenic model}
\usage{
plotRes(x, labels = FALSE, text.size = 4, ...)

plotResQQ(x, distribution = "norm", ..., line.estimate = NULL, conf = 0.9,
  labels = FALSE, text.size = 4)
}
\arguments{
\item{x}{An object of class \code{solarPolygenic}.}

\item{labels}{A logical value for \code{plotRes} function, indicating if the labels of IDs
(which residuals are outside the 3 * sd interval) are to be plotted.
A logical value for \code{plotResQQ} function,
indicating if the samples (their IDs) outside the confidence intervals are to be plotted.}

\item{text.size}{An integer, the text size of labels.}

\item{...}{additional arguments.}

\item{distribution}{A character, name of distribution of the residuals.
The default value is \code{"norm"}.}

\item{line.estimate}{Function for estimation of QQ-line.}

\item{conf}{A numeric value between 0 and 1, that represents the confidence boundary.}
}
\description{
Plot the residuals on scatter or quantile-quantile plots.
}
\details{
\code{plotRes} function makes a scatter plot of fitted values vs. residuals.
Note that the residuals returned by SOLAR include both random effects,
i.e. house-hold, genetic and residuals itself.

\code{plotResQQ} function plots  quantile-quantile (QQ) plot of the residuals.
}
\examples{
\dontrun{
### basic (univariate) polygenic model
mod <- solarPolygenic(trait1 ~ age + sex, dat30)

plotRes(mod)

plotResQQ(mod)

}
}
\seealso{
\code{\link{solarPolygenicClass}}
}

