% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HourAngle.R
\name{HourAngle}
\alias{HourAngle}
\title{Solar Hour Angle}
\usage{
HourAngle(DOY, Lon, SLon, DS)
}
\arguments{
\item{DOY}{Day of year}

\item{Lon}{Longitude in degrees}

\item{SLon}{Standard longitude (based on time zone) in degrees}

\item{DS}{Daylight saving in minutes}
}
\description{
This function returns solar hour angle for a given day of year, and location.
}
\examples{

#Calculating solar hour angle for two consecutive days

DOY <- seq(0, 2, .05)

h <- HourAngle(DOY, Lon=0, SLon=0, DS=60)
#Note: only the difference between Lon and SLon matters not each value

plot(DOY, h)

}
\keyword{Angle}
\keyword{Hour}
