% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection_delete.R
\name{collection_delete}
\alias{collection_delete}
\title{Add a collection}
\usage{
collection_delete(conn, name, raw = FALSE, callopts = list())
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{name}{(character) The name of the core to be created. Required}

\item{raw}{(logical) If \code{TRUE}, returns raw data}

\item{callopts}{curl options passed on to \code{\link[crul]{HttpClient}}}
}
\description{
Add a collection
}
\examples{
\dontrun{
(conn <- SolrClient$new())

if (!conn$collection_exists("helloWorld")) {
  conn$collection_create(name = "helloWorld")
}

collection_delete(conn, name = "helloWorld")
}
}
