% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/som.nn.do.train.R
\name{som.nn.do.train}
\alias{som.nn.do.train}
\title{Work hourse for hexagonal som training}
\usage{
som.nn.do.train(x, class.idx, kernel, xdim, ydim, toroidal, len, alpha,
  radius = 0, norm, norm.center, norm.scale, dist.fun, max.dist, name,
  continue, len.total, codes)
}
\arguments{
\item{x}{data.fame with training data. Samples are requested as rows and taken randomly for the
training steps. All
columns except of the class lables are considered to be attributes and parts of
the training vector.
One column is needed as class labels. The column with class
lables is selected by the argument \code{class.col}.
If class is not given, the first column is used as class labels.}

\item{xdim}{dimension in x-direction.}

\item{ydim}{dimension in y-direction.}

\item{toroidal}{\code{logical}; if TRUE an endless som is trained as on the
surface of a torus.}

\item{len}{number of steps to be trained (steps - not epochs!).}

\item{alpha}{initial training rate.}

\item{radius}{inital radius for SOM training.
Gaussian distance function is used, radius corresponds to sigma.}

\item{norm}{logical; if TRUE, input data is normalised with \code{scale(x, TRUE, TRUE)}.}

\item{dist.fun}{parameter for k-NN prediction. Function is used to calculate
distance-dependent weights. Any distance function must accept the two parameters
\code{x} (distance) and \code{sigma} (maximum distance to give a weight > 0.0).}

\item{max.dist}{parameter for k-NN prediction. Parameter \code{sigma} for dist.fun.
In order to avoid rounding issues, it is recommended not to 
use exact integers as limit, but values like 1.1 to make sure, that all 
neurons with distance 1 are included.}

\item{name}{name for the model. Name will be stored as slot \code{model@name} in the
trained model.}

\item{continue}{logical; if TRUE, the codebook vectors of the model, given in argument \code{model} will be used
as initial codes.}

\item{len.total}{number of previuos training steps.}

\item{class.col}{index of the column with as class labels
(after beeing coerced to character).}

\item{model}{model of type \code{SOMnn}.}
}
\value{
S4 object of type \code{\link{SOMnn}} with the trained model
}
\description{
The function is called by \code{\link{som.nn.train}} and \code{\link{som.nn.continue}} 
to train self-organising map with hexagonal tolology.
}
\keyword{internal}

