% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_happycat.R
\name{generate_happycat_function}
\alias{generate_happycat_function}
\title{Generator for the Happycat function.}
\usage{
generate_happycat_function(dimensions, alpha = 0.125)
}
\arguments{
\item{dimensions}{[\code{integer(1)}] Size of parameter space.}

\item{alpha}{[\code{numeric(1)}] Parameter for control of groove shape.}
}
\value{
A \code{soo_function}.
}
\description{
The definition used is
}
\details{
\deqn{
  f(x) =
    \left((x^Tx - n)^2\right)^\alpha
    + \frac{1}{N}\left(
      \frac{1}{2}x^Tx + \sum_{i=1}^n x_i
    \right) + \frac{1}{2}}
}
\examples{
f <- generate_happycat_function(2, 1/8)
plot(f)

}
\references{
H.-G. Beyer and S. Finck. HappyCat - A Simple Function Class
  Where Well-Known Direct Search Algorithms Do Fail.
  In: PPSN XII (Parallel Problem Solving from Nature), 367-376,
  Springer, Heidelberg, 2012.
}
