% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{vec2df.rank}
\alias{vec2df.rank}
\title{A vector to data frame converter for \code{\link{fitTable}}. This one orders data by rank.}
\usage{
vec2df.rank(data)
}
\arguments{
\item{data}{[numeric vector] The data to be converted.}
}
\value{
[data.frame] Converted \code{data}.
}
\description{
A vector to data frame converter for \code{\link{fitTable}}. This one orders data by rank.
}
\examples{
dataset <- summary (sampleSoundCorrsData.abc)
models <- list (
	"model A" = list (
		formula = "Y ~ a/X",
		start = list (list(a=1))),
	"model B" = list (
		formula = "Y ~ a/(1+exp(1)^X)",
		start = list (list(a=1)))
)
fitTable (models, dataset, 1, vec2df.rank)
}
