% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{ngrams}
\alias{ngrams}
\title{Frequencies of n-grams.}
\usage{
ngrams(data, n, zeros, as.table)
}
\arguments{
\item{data}{[scOne] A \code{\link{scOne}} object in which to look for n-grams.}

\item{n}{[integer] The length of n-grams to look for. Defaults to \code{1}.}

\item{zeros}{[logical] Include linguistic zeros? Defaults to \code{TRUE}.}

\item{as.table}{[logical] Return the result as a table? Defaults to \code{TRUE}.}
}
\value{
[table] Table with counts of n-grams.
}
\description{
Find n-grams of specified length and return their counts.
}
\examples{
# path to sample data in the "wide format"
fNameData <- system.file ("extdata", "data-capitals.tsv", package="soundcorrs")
# path to a sample transcription
fNameTrans <- system.file ("extdata", "trans-common.tsv", package="soundcorrs")
d.cap.ger <- read.scOne (fNameData, "German", "ALIGNED.German", fNameTrans)
ngrams (d.cap.ger, 2)
ngrams (d.cap.ger, 2, FALSE)
}
