% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectralDescr.R
\name{harmHeight}
\alias{harmHeight}
\title{Height of harmonics}
\usage{
harmHeight(
  frame,
  pitch,
  bin,
  freqs,
  harmThres = 3,
  harmTol = 0.25,
  harmPerSel = 5
)
}
\arguments{
\item{frame}{the abs spectrum of a frame, as returned by
\code{\link[stats]{fft}}}

\item{pitch}{the final pitch estimate for the current frame}

\item{bin}{spectrogram bin width, Hz}

\item{freqs}{frequency per bin of spectrogram}

\item{harmThres}{minimum height of spectral peak, dB}

\item{harmTol}{maximum tolerated deviation of peak frequency from multiples
of f0, proportion of f0}

\item{harmPerSel}{the number of harmonics per sliding selection}
}
\value{
Returns the frequency (Hz) up to which we find harmonics
}
\description{
Internal soundgen function
}
\details{
Attempts to estimate how high harmonics reach in the spectrum - that is, at
what frequency we can still discern peaks at multiples of f0 or, for
low-pitched sounds, regularly spaced peaks separated by ~f0.
}
\examples{
s = soundgen(sylLen = 400, addSilence = 0, pitch = 400, noise = -10,
  rolloff = -15, jitterDep = .1, shimmerDep = 5, temperature = .001)
sp = spectrogram(s, samplingRate = 16000)
hh = soundgen:::harmHeight(sp[, 5], pitch = 400,
  freqs = as.numeric(rownames(sp)) * 1000, bin = 16000 / 2 / nrow(sp))
}
\keyword{internal}
