% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiftFormants.R
\name{.shiftFormants}
\alias{.shiftFormants}
\title{Shift formants per sound}
\usage{
.shiftFormants(
  audio,
  multFormants,
  freqWindow = NULL,
  spec = NULL,
  dynamicRange = 80,
  windowLength = 50,
  step = NULL,
  overlap = 75,
  wn = "gaussian",
  interpol = c("approx", "spline")[1],
  normalize = c("max", "orig", "none")[2],
  play = FALSE
)
}
\arguments{
\item{audio}{a list returned by \code{readAudio}}

\item{multFormants}{1 = no change, >1 = raise formants (eg 1.1 = 10\% up, 2 =
one octave up), <1 = lower formants. Anchor format accepted (see
\code{\link{soundgen}})}

\item{freqWindow}{the width of spectral smoothing window, Hz. Defaults to
detected f0}

\item{spec}{precomputed spectrogram}

\item{dynamicRange}{dynamic range, dB. All values more than one dynamicRange
under maximum are treated as zero}

\item{windowLength}{length of FFT window, ms}

\item{step}{you can override \code{overlap} by specifying FFT step, ms (NB:
because digital audio is sampled at discrete time intervals of
1/samplingRate, the actual step and thus the time stamps of STFT frames
may be slightly different, eg 24.98866 instead of 25.0 ms)}

\item{overlap}{overlap between successive FFT frames, \%}

\item{wn}{window type accepted by \code{\link[seewave]{ftwindow}}, currently
gaussian, hanning, hamming, bartlett, blackman, flattop, rectangle}

\item{interpol}{the method for interpolating scaled spectra}

\item{normalize}{"orig" = same as input (default), "max" = maximum possible
peak amplitude, "none" = no normalization}

\item{play}{if TRUE, plays the synthesized sound using the default player on
your system. If character, passed to \code{\link[tuneR]{play}} as the name
of player to use, eg "aplay", "play", "vlc", etc. In case of errors, try
setting another default player for \code{\link[tuneR]{play}}}
}
\description{
Internal soundgen function called by \code{\link{shiftFormants}}
}
\keyword{internal}
