% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_investments_expense.R
\name{plot_investments_expense}
\alias{plot_investments_expense}
\title{Plot the Investments and Expenses}
\usage{
plot_investments_expense(investment_vector, expense_vector, output_path)
}
\arguments{
\item{investment_vector}{a vector of annual investments}

\item{expense_vector}{a vector of annual withdrawals}

\item{output_path}{file path to a folder in which the graph will be saved,
NULL indicates plot, don't save}
}
\value{
No explicit returned values, merely the side-effects of a graph
named 'investments_expense.png' written to output_path
}
\description{
Produces a plot of the investments, expenses and net investment.

#@details
}
\examples{
\dontrun{
investment_vector <- seq(1,30)*10
expense_vector <- c(investment_vector[1:10]  * 0.15,
                   investment_vector[11:20] * 0.35,
                   investment_vector[21:30] * runif(10, min=0.01, max=0.90))
plot_investments_expense(investment_vector,
                         expense_vector,
                         output_path=NULL)
}

}
\author{
George Fisher
}

