% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smap.R
\name{smap}
\alias{smap}
\alias{smap,sf-method}
\alias{smap,SpatRaster-method}
\title{smap forecasting}
\usage{
\S4method{smap}{sf}(
  data,
  target,
  lib,
  pred = lib,
  E = 3,
  k = 4,
  theta = c(0, 1e-04, 3e-04, 0.001, 0.003, 0.01, 0.03, 0.1, 0.3, 0.5, 0.75, 1, 1.5, 2, 3,
    4, 6, 8),
  nb = NULL,
  threads = detectThreads(),
  include.self = FALSE
)

\S4method{smap}{SpatRaster}(
  data,
  target,
  lib,
  pred = lib,
  E = 3,
  k = 4,
  theta = c(0, 1e-04, 3e-04, 0.001, 0.003, 0.01, 0.03, 0.1, 0.3, 0.5, 0.75, 1, 1.5, 2, 3,
    4, 6, 8),
  threads = detectThreads(),
  include.self = FALSE
)
}
\arguments{
\item{data}{The observation data.}

\item{target}{Name of target variable.}

\item{lib}{The row numbers(\code{vector}) of lattice data or the row-column numbers(\code{matrix}) of grid data for creating the library from observations.}

\item{pred}{(optional) The row numbers(\code{vector}) of lattice data or the row-column numbers(\code{matrix}) of grid data used for predictions.}

\item{E}{(optional) The dimensions of the embedding.}

\item{k}{(optional) Number of nearest neighbors to use for prediction.}

\item{theta}{(optional) Weighting parameter for distances}

\item{nb}{(optional) The neighbours list.}

\item{threads}{(optional) Number of threads.}

\item{include.self}{(optional) Whether to include the current state when constructing the embedding vector.}
}
\value{
A matrix
}
\description{
smap forecasting
}
\examples{
columbus = sf::read_sf(system.file("shapes/columbus.gpkg", package="spData")[1],
                       quiet=TRUE)
\donttest{
smap(columbus,target = "INC",lib = 1:49)
}
}
