% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spinar_penal.R
\name{spinar_penal}
\alias{spinar_penal}
\title{Penalized semiparametric estimation of INAR models}
\usage{
spinar_penal(x, p, penal1 = 0, penal2 = 0)
}
\arguments{
\item{x}{[\code{integer}]\cr
vector with integer observations.}

\item{p}{[\code{integer(1)}]\cr
order of the INAR model, where \eqn{\code{p} \in \{1,2\}}.}

\item{penal1}{\eqn{L_1} penalization parameter (default value zero results in no \eqn{L_1} penalization)}

\item{penal2}{\eqn{L_2} penalization parameter (default value zero results in  no \eqn{L_2} penalization)}
}
\value{
Vector containing the penalized estimated coefficients \eqn{\code{alpha}_1,...,\code{alpha}_p} and the penalized
estimated entries of the pmf \eqn{\code{pmf}_0, \code{pmf}_1},... where \eqn{\code{pmf}_i} represents the probability of
an innovation being equal to \eqn{i}.
}
\description{
Semiparametric penalized estimation of the autoregressive parameters and the innovation distribution of INAR(\code{p}) models,
\eqn{\code{p} \in \{1,2\}}. The estimation is conducted by maximizing the penalized conditional likelihood of the model. If both
penalization parameters are set to zero, the function coincides to the spinar_est function of this package.
}
\examples{
# generate data
dat1 <- spinar_sim(n = 50, p = 1, alpha = 0.5,
                   pmf = c(0.3, 0.25, 0.2, 0.15, 0.1))

# penalized semiparametric estimation
spinar_penal(x = dat1, p = 1, penal1 = 0, penal2 = 0.1)

}
