% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{tnkdediscontinuousfunctionsparse}
\alias{tnkdediscontinuousfunctionsparse}
\alias{discontinuous_tnkde_cpp_arma_sparse}
\title{The main function to calculate discontinuous NKDE (ARMA and sparse matrix)}
\usage{
discontinuous_tnkde_cpp_arma_sparse(
  neighbour_list,
  events,
  weights,
  events_time,
  samples,
  samples_time,
  bws_net,
  bws_time,
  kernel_name,
  nodes,
  line_list,
  max_depth,
  verbose,
  div = "bw"
)
}
\arguments{
\item{neighbour_list}{a list of the neighbours of each node}

\item{events}{a numeric vector of the node id of each event}

\item{weights}{a numeric vector of the weight of each event}

\item{events_time}{a numeric vector with the time for the events}

\item{samples}{a DataFrame of the samples (with spatial coordinates and belonging edge)}

\item{samples_time}{a NumericVector indicating when to do the samples}

\item{bws_net}{the network kernel bandwidths for each event}

\item{kernel_name}{the name of the kernel function to use}

\item{nodes}{a DataFrame representing the nodes of the graph (with spatial coordinates)}

\item{line_list}{a DataFrame representing the lines of the graph}

\item{max_depth}{the maximum recursion depth (after which recursion is stopped)}

\item{verbose}{a boolean indicating if the function must print its progress}

\item{div}{a string indicating how to standardize the kernel values}
}
\value{
a List with two matrices: the kernel values (sum_k) and the number of events for each sample (n)
}
\description{
The main function to calculate discontinuous NKDE (ARMA and sparse matrix)
}
\keyword{internal}
