\name{spacodi.permutplot}
\alias{spacodi.permutplot}
\title{EXPERIMENTAL: plotting observed and expected community structure across branching times of a phylogeny}

\description{\code{spacodi.permutplot} is a function used to plot departures from null expectations of diversity turnover, nodewise for a phylogeny.}

\usage{
  spacodi.permutplot(spacodi.permutations, cex=list(pch=1.5, rand=0.1, node=0.5, legend=0.75), transp=0.8, col = list("black", "lightgray"), 
  bg = list("white", "lightgray", "black"), all.points = TRUE, add.id = TRUE, sig.plot = TRUE, cut.off = 0.05, envelope = FALSE, outfile = NULL, ...)
}

\arguments{
  \item{spacodi.permutations}{a list-object generated by \code{\link{spacodi.by.nodes}}} 
  \item{cex}{a named list of scalings for node symbols (\code{pch}), permutations (\code{rand}), \code{node} labels, and \code{legend}}
  \item{transp}{degree of color transparency: \code{transp=1} is opaque}
  \item{col}{a list of two elements: colors to be used for plotting observed and expected community structure}
  \item{bg}{a list of background (fill) colors to be used for plotting observed and expected community structure}
  \item{all.points}{Boolean; whether all permutation estimates are to be plotted}
  \item{add.id}{Boolean; whether \code{node.labels} are placed near nodewise estimates of community structure}
  \item{sig.plot}{Boolean; whether nodes are colored by significance of observed and expected estimates of structure}
  \item{cut.off}{a value, if \code{sig.plot=TRUE}, distinguishing observed from expected estimates of structure}
  \item{envelope}{Boolean; whether a smooth-spline envelope is drawn around permutation estimates of structure}
  \item{outfile}{an optional .pdf file to which to write output}
  \item{\dots}{additional plotting parameters to be optionally supplied}
}

\details{
  This function generates a plot of diversity turnover, evaluated for each subtree of the supplied phylogeny. 
  If \code{all.points=TRUE}, empirical estimates of structure as well as those expected from permuted community datasets are plotted together. 
  Several methods are available for data permutation when using \code{\link{spacodi.by.nodes}}, typically the function used 
  to generate \code{spacodi.permutations}. 
}

\value{a plot of diversity structure estimates for a phylogeny, with the option to direct output to a .pdf file}

\author{Jonathan Eastman}


\seealso{\code{\link{spacodi.calc}} for further details on diversity structure; \code{\link{spacodi.by.nodes}}; \code{\link[stats]{smooth.spline}}}

\examples{
# load a species-by-plots matrix, along with a tree
data(sp.example)
attach(sp.example)
spl
phy

# generate a plot of observed and expected Bst
sp.permut=spacodi.by.nodes(sp.plot=spl, phy=phy, n.rep=10)
spacodi.permutplot(sp.permut,bty="n")
}