\name{spacodi.treeplot}
\alias{spacodi.treeplot}

\title{EXPERIMENTAL: plotting diversity turnover on trees}
\description{\code{spacodi.treeplot} is used to plot departures from expectations for diversity turnover on a phylogeny}

\usage{spacodi.treeplot(spacodi.permutations, phy, cex=list(pch = 1.5, tip = 0.5, legend = 0.75), transp=0.8, sig.plot = TRUE, cut.off = 0.05, cols = list("white", "gray", "black"), main = TRUE, outfile = NULL, add.id = FALSE, ...)}

\arguments{
  \item{spacodi.permutations}{a list-object generated by \code{\link{spacodi.by.nodes}}}
  \item{phy}{a phylogenetic tree of class \code{phylo}; see \code{\link[ape]{read.tree}}}
  \item{cex}{a named list of character scalings for node-associated symbols (\code{pch}), tip labels (\code{tip}), and the legend (\code{legend})}
  \item{transp}{degree of color transparency: \code{transp=1} is opaque}
  \item{sig.plot}{Boolean; whether nodes are colored by significance of observed and expected estimates of structure}
  \item{cut.off}{a value, if \code{sig.plot=TRUE}, distinguishing observed from expected estimates of structure}
  \item{cols}{a list of three elements if using \code{sig.plot}: the first color is for values not different than expected; the second and third for values greater and less than expected}
  \item{main}{Boolean; whether a title is plotted}
  \item{outfile}{an optional .pdf file to which to write output}
  \item{add.id}{Boolean; whether \code{node.labels} are placed near nodes; see \code{\link[ape]{nodelabels}}}
  \item{\dots}{additional plotting parameters to be optionally supplied}
}

\details{
This function will compute and plot estimates of diversity structure on the tree, with color-coded values.

Note: this function requires a \code{spacodi.permutations} with data for all nodes.  If using, for instance, \code{spacodi.by.nodes} to
generate these data, the option \code{obs.only=TRUE} will ensure that data are returned for all nodes (see \strong{Examples} below).
}

\value{a plot of diversity structure estimates for a phylogeny, with the option to direct output to a .pdf file}

\references{
  HARDY OJ and B SENTERRE. 2007. Characterizing the 
  phylogenetic structure of communities by an additive partitioning of 
  phylogenetic diversity. Journal of Ecology 95:493-506.
  
  HARDY OJ. 2008. Testing the spatial phylogenetic 
  structure of local communities: statistical performances of 
  different null models and test statistics on a locally neutral 
  community. Journal of Ecology 96:914-926.
}

\author{Timothy Paine and Jonathan Eastman}

\seealso{
see \code{\link{spacodi.by.nodes}} for estimating phylogenetic turnover on trees with community-level sampling; 
\code{\link{spacodi.permutplot}}; \code{\link{phy.dotplot}} }

\examples{
data(sp.example)
attach(sp.example)

# plot PIst 
PI=spacodi.by.nodes(sp.plot=spl, sp.parm="PIst", phy=phy, return.all=TRUE, method="1s")
spacodi.treeplot(PI, phy, sig.plot=TRUE, add.id=FALSE)
spacodi.treeplot(PI, phy, sig.plot=FALSE, add.id=FALSE)


}
