% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spacy_tokenize.R
\name{spacy_tokenize}
\alias{spacy_tokenize}
\title{Tokenize text with spaCy}
\usage{
spacy_tokenize(
  x,
  what = c("word", "sentence"),
  remove_punct = FALSE,
  remove_url = FALSE,
  remove_numbers = FALSE,
  remove_separators = TRUE,
  remove_symbols = FALSE,
  padding = FALSE,
  multithread = TRUE,
  output = c("list", "data.frame"),
  ...
)
}
\arguments{
\item{x}{a character object, a \pkg{quanteda} corpus, or a TIF-compliant
corpus data.frame (see \url{https://github.com/ropensci/tif})}

\item{what}{the unit for splitting the text, available alternatives are: 
\describe{ \item{\code{"word"}}{word segmenter} 
\item{\code{"sentence"}}{sentence segmenter }}}

\item{remove_punct}{remove punctuation tokens.}

\item{remove_url}{remove tokens that look like a url or email address.}

\item{remove_numbers}{remove tokens that look like a number (e.g. "334", "3.1415", "fifty").}

\item{remove_separators}{remove spaces as separators when
all other remove functionalities (e.g. \code{remove_punct}) have to be set to \code{FALSE}. 
When \code{what = "sentence"}, this option will remove trailing spaces if \code{TRUE}.}

\item{remove_symbols}{remove symbols. The symbols are either \code{SYM} in \code{pos}
field, or currency symbols.}

\item{padding}{if \code{TRUE}, leave an empty string where the removed tokens 
previously existed. This is useful if a positional match is needed between 
the pre- and post-selected tokens, for instance if a window of adjacency 
needs to be computed.}

\item{multithread}{logical; If \code{TRUE}, the processing is parallelized
using spaCy's architecture (\url{https://spacy.io/api})}

\item{output}{type of returning object. Either \code{list} or \code{data.frame}.}

\item{...}{not used directly}
}
\value{
either \code{list} or \code{data.frame} of tokens
}
\description{
Efficient tokenization (without POS tagging, dependency parsing,
lemmatization, or named entity recognition) of texts using spaCy.
}
\examples{
\donttest{
spacy_initialize()
txt <- "And now for something completely different."
spacy_tokenize(txt)

txt2 <- c(doc1 = "The fast cat catches mice.\\\\nThe quick brown dog jumped.", 
          doc2 = "This is the second document.",
          doc3 = "This is a \\\\\"quoted\\\\\" text." )
spacy_tokenize(txt2)
}
}
