% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdf_utils.R
\name{ts_rdd_builder}
\alias{ts_rdd_builder}
\title{TimeSeriesRDD builder object}
\usage{
ts_rdd_builder(
  sc,
  is_sorted = FALSE,
  time_unit = .sparklyr.flint.globals$kValidTimeUnits,
  time_column = .sparklyr.flint.globals$kDefaultTimeColumn
)
}
\arguments{
\item{sc}{Spark connection}

\item{is_sorted}{Whether the rows being imported are already sorted by time}

\item{time_unit}{Time unit of the time column (must be one of the following
values: "NANOSECONDS", "MICROSECONDS", "MILLISECONDS", "SECONDS",
"MINUTES", "HOURS", "DAYS"}

\item{time_column}{Name of the time column}
}
\value{
A reusable TimeSeriesRDD builder object
}
\description{
Builder object containing all required info (i.e., isSorted, timeUnit, and
timeColumn) for importing a Spark data frame into a TimeSeriesRDD
}
