% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stream_data.R
\name{stream_write_parquet}
\alias{stream_write_parquet}
\title{Write Parquet Stream}
\usage{
stream_write_parquet(x, path, mode = c("append", "complete", "update"),
  trigger = stream_trigger_interval(), checkpoint = file.path(path,
  "checkpoints", random_string("")), options = list(), ...)
}
\arguments{
\item{x}{A Spark DataFrame or dplyr operation}

\item{path}{The destination path. Needs to be accessible from the cluster.
Supports the \samp{"hdfs://"}, \samp{"s3a://"} and \samp{"file://"} protocols.}

\item{mode}{Specifies how data is written to a streaming sink. Valid values are
\code{"append"}, \code{"complete"} or \code{"update"}.}

\item{trigger}{The trigger for the stream query, defaults to micro-batches runnnig
every 5 seconds. See \code{\link{stream_trigger_interval}} and
\code{\link{stream_trigger_continuous}}.}

\item{checkpoint}{The location where the system will write all the checkpoint
information to guarantee end-to-end fault-tolerance.}

\item{options}{A list of strings with additional options.}

\item{...}{Optional arguments; currently unused.}
}
\description{
Writes a Spark dataframe stream into a parquet stream.
}
\examples{
\dontrun{

sc <- spark_connect(master = "local")

sdf_len(sc, 10) \%>\% spark_write_parquet("parquet-in")

stream <- stream_read_parquet(sc, "parquet-in") \%>\% stream_write_parquet("parquet-out")

stream_stop(stream)

}

}
\seealso{
Other Spark stream serialization: \code{\link{stream_read_csv}},
  \code{\link{stream_read_jdbc}},
  \code{\link{stream_read_json}},
  \code{\link{stream_read_kafka}},
  \code{\link{stream_read_orc}},
  \code{\link{stream_read_parquet}},
  \code{\link{stream_read_text}},
  \code{\link{stream_write_csv}},
  \code{\link{stream_write_jdbc}},
  \code{\link{stream_write_json}},
  \code{\link{stream_write_kafka}},
  \code{\link{stream_write_memory}},
  \code{\link{stream_write_orc}},
  \code{\link{stream_write_text}}
}
\concept{Spark stream serialization}
