% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_feature_quantile_discretizer.R
\name{ft_quantile_discretizer}
\alias{ft_quantile_discretizer}
\title{Feature Transformation -- QuantileDiscretizer (Estimator)}
\usage{
ft_quantile_discretizer(x, input_col = NULL, output_col = NULL,
  num_buckets = 2, input_cols = NULL, output_cols = NULL,
  num_buckets_array = NULL, handle_invalid = "error",
  relative_error = 0.001, uid = random_string("quantile_discretizer_"),
  ...)
}
\arguments{
\item{x}{A \code{spark_connection}, \code{ml_pipeline}, or a \code{tbl_spark}.}

\item{input_col}{The name of the input column.}

\item{output_col}{The name of the output column.}

\item{num_buckets}{Number of buckets (quantiles, or categories) into which data
points are grouped. Must be greater than or equal to 2.}

\item{input_cols}{Names of input columns.}

\item{output_cols}{Names of output columns.}

\item{num_buckets_array}{Array of number of buckets (quantiles, or categories)
into which data points are grouped. Each value must be greater than or equal to 2.}

\item{handle_invalid}{(Spark 2.1.0+) Param for how to handle invalid entries. Options are
'skip' (filter out rows with invalid values), 'error' (throw an error), or
'keep' (keep invalid values in a special additional bucket). Default: "error"}

\item{relative_error}{(Spark 2.0.0+) Relative error (see documentation for
org.apache.spark.sql.DataFrameStatFunctions.approxQuantile
\href{https://spark.apache.org/docs/latest/api/scala/index.html#org.apache.spark.sql.DataFrameStatFunctions}{here}
for description). Must be in the range [0, 1]. default: 0.001}

\item{uid}{A character string used to uniquely identify the feature transformer.}

\item{...}{Optional arguments; currently unused.}
}
\value{
The object returned depends on the class of \code{x}.

\itemize{
  \item \code{spark_connection}: When \code{x} is a \code{spark_connection}, the function returns a \code{ml_transformer},
  a \code{ml_estimator}, or one of their subclasses. The object contains a pointer to
  a Spark \code{Transformer} or \code{Estimator} object and can be used to compose
  \code{Pipeline} objects.

  \item \code{ml_pipeline}: When \code{x} is a \code{ml_pipeline}, the function returns a \code{ml_pipeline} with
  the transformer or estimator appended to the pipeline.

  \item \code{tbl_spark}: When \code{x} is a \code{tbl_spark}, a transformer is constructed then
  immediately applied to the input \code{tbl_spark}, returning a \code{tbl_spark}
}
}
\description{
\code{ft_quantile_discretizer} takes a column with continuous features and outputs
  a column with binned categorical features. The number of bins can be
  set using the \code{num_buckets} parameter. It is possible that the number
  of buckets used will be smaller than this value, for example, if there
  are too few distinct values of the input to create enough distinct
  quantiles.
}
\details{
NaN handling: null and NaN values will be ignored from the column
  during \code{QuantileDiscretizer} fitting. This will produce a \code{Bucketizer}
  model for making predictions. During the transformation, \code{Bucketizer}
  will raise an error when it finds NaN values in the dataset, but the
  user can also choose to either keep or remove NaN values within the
  dataset by setting \code{handle_invalid} If the user chooses to keep NaN values,
  they will be handled specially and placed into their own bucket,
  for example, if 4 buckets are used, then non-NaN data will be put
  into buckets[0-3], but NaNs will be counted in a special bucket[4].

Algorithm: The bin ranges are chosen using an approximate algorithm (see
  the documentation for org.apache.spark.sql.DataFrameStatFunctions.approxQuantile
  \href{https://spark.apache.org/docs/latest/api/scala/index.html#org.apache.spark.sql.DataFrameStatFunctions}{here} for a detailed description). The precision of the approximation can be
  controlled with the \code{relative_error} parameter. The lower and upper bin
  bounds will be -Infinity and +Infinity, covering all real values.

Note that the result may be different every time you run it, since the sample
  strategy behind it is non-deterministic.

In the case where \code{x} is a \code{tbl_spark}, the estimator fits against \code{x}
  to obtain a transformer, which is then immediately used to transform \code{x}, returning a \code{tbl_spark}.
}
\seealso{
See \url{http://spark.apache.org/docs/latest/ml-features.html} for
  more information on the set of transformations available for DataFrame
  columns in Spark.

\code{\link{ft_bucketizer}}

Other feature transformers: \code{\link{ft_binarizer}},
  \code{\link{ft_bucketizer}},
  \code{\link{ft_chisq_selector}},
  \code{\link{ft_count_vectorizer}}, \code{\link{ft_dct}},
  \code{\link{ft_elementwise_product}},
  \code{\link{ft_feature_hasher}},
  \code{\link{ft_hashing_tf}}, \code{\link{ft_idf}},
  \code{\link{ft_imputer}},
  \code{\link{ft_index_to_string}},
  \code{\link{ft_interaction}}, \code{\link{ft_lsh}},
  \code{\link{ft_max_abs_scaler}},
  \code{\link{ft_min_max_scaler}}, \code{\link{ft_ngram}},
  \code{\link{ft_normalizer}},
  \code{\link{ft_one_hot_encoder}}, \code{\link{ft_pca}},
  \code{\link{ft_polynomial_expansion}},
  \code{\link{ft_r_formula}},
  \code{\link{ft_regex_tokenizer}},
  \code{\link{ft_sql_transformer}},
  \code{\link{ft_standard_scaler}},
  \code{\link{ft_stop_words_remover}},
  \code{\link{ft_string_indexer}},
  \code{\link{ft_tokenizer}},
  \code{\link{ft_vector_assembler}},
  \code{\link{ft_vector_indexer}},
  \code{\link{ft_vector_slicer}}, \code{\link{ft_word2vec}}
}
\concept{feature transformers}
