% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_pipeline_utils.R
\name{spark_pipeline_stage}
\alias{spark_pipeline_stage}
\title{Create a Pipeline Stage Object}
\usage{
spark_pipeline_stage(
  sc,
  class,
  uid,
  features_col = NULL,
  label_col = NULL,
  prediction_col = NULL,
  probability_col = NULL,
  raw_prediction_col = NULL,
  k = NULL,
  max_iter = NULL,
  seed = NULL,
  input_col = NULL,
  input_cols = NULL,
  output_col = NULL,
  output_cols = NULL
)
}
\arguments{
\item{sc}{A `spark_connection` object.}

\item{class}{Class name for the pipeline stage.}

\item{uid}{A character string used to uniquely identify the ML estimator.}

\item{features_col}{Features column name, as a length-one character vector. The column should be single vector column of numeric values. Usually this column is output by \code{\link{ft_r_formula}}.}

\item{label_col}{Label column name. The column should be a numeric column. Usually this column is output by \code{\link{ft_r_formula}}.}

\item{prediction_col}{Prediction column name.}

\item{probability_col}{Column name for predicted class conditional probabilities.}

\item{raw_prediction_col}{Raw prediction (a.k.a. confidence) column name.}

\item{k}{The number of clusters to create}

\item{max_iter}{The maximum number of iterations to use.}

\item{seed}{A random seed. Set this value if you need your results to be
reproducible across repeated calls.}

\item{input_col}{The name of the input column.}

\item{input_cols}{Names of output columns.}

\item{output_col}{The name of the output column.}
}
\description{
Helper function to create pipeline stage objects with common parameter setters.
}
\keyword{internal}
