% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jitter_power.R
\name{jitter_power}
\alias{jitter_power}
\title{Power of SRR function for previously collected data.}
\usage{
jitter_power(
  obs_data,
  sim_total,
  samp_control = c("uniform", "CSR", "MVN"),
  s_control = 1,
  cascon = FALSE,
  lower_tail = 0.025,
  upper_tail = 0.975,
  parallel = FALSE,
  n_core = 2,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{obs_data}{A bivariate point pattern (a multitype point pattern of object of class "ppp") with two types of points in a factor valued mark.}

\item{sim_total}{Integer, specifying the number of simulation iterations to perform.}

\item{samp_control}{Character string specifying whether to randomize the control locations uniformly (\code{samp_control="uniform"}), with complete spatial randomness (\code{samp_control="CSR"}), or multivariate normal (\code{samp_control="MVN"}).}

\item{s_control}{Optional. Numeric value for the standard deviation of the multivariate normal distribution in the units of the \code{obs_data}.  The default value (1) assumes a unit square window. Ignored if Ignored if \code{samp_control="uniform"} or \code{samp_control="CSR"}.}

\item{cascon}{Logical. If FALSE (the default) computes the power to detect only relative case clustering. If TRUE, computes power to detect both case and control clustering.}

\item{lower_tail}{Optional. Numeric value of lower p-value threshold (default=0.025).}

\item{upper_tail}{Optional. Numeric value of upper p-value threshold (default=0.975). Ignored if cascon=FALSE.}

\item{parallel}{Logical. If TRUE, will execute the function in parallel. If FALSE (the default), will not execute the function in parallel.}

\item{n_core}{Optional. Integer specifying the number of CPU cores on current host to use for parallelization (the default is 2 cores).}

\item{verbose}{Logical. If TRUE (the default), will print function progress during execution. If FALSE, will not print.}

\item{...}{Arguments passed to \code{\link[sparr]{risk}} to select bandwidth, edge correction, and resolution.}
}
\value{
An object of class "list". This is a named list with the following components:

\describe{
\item{\code{sim}}{An object of class 'rrs' for the first iteration of simulated data.}
\item{\code{out}}{An object of class 'rrs' for the observed spatial relative risk function without randomization.}
\item{\code{rr_mean}}{Vector of length \code{[resolution x resolution]} of the mean relative risk values at each gridded knot.}
\item{\code{pval_mean}}{Vector of length \code{[resolution x resolution]} of the mean asymptotic p-value at each gridded knot.}
\item{\code{rr_sd}}{Vector of length \code{[resolution x resolution]} of the standard deviation of relative risk values at each gridded knot.}
\item{\code{rr_mean}}{Vector of length \code{[resolution x resolution]} of the proportion of asymptotic p-values that were significant at each gridded knot.}
\item{\code{rx}}{Vector of length \code{[resolution x resolution]} of the x-coordinates of each gridded knot.}
\item{\code{ry}}{Vector of length \code{[resolution x resolution]} of the y-coordinates of each gridded knot.}
\item{\code{rx}}{Vector of length \code{sim_total} of the number of control locations simulated in each iteration.}
\item{\code{bandw}}{Vector of length \code{sim_total} of the bandwidth (of numerator) used in each iteration.}
\item{\code{bandw}}{Vector of length \code{sim_total} of the global s statistic.}
\item{\code{bandw}}{Vector of length \code{sim_total} of the global t statistic.}
}
}
\description{
Compute the statistical power of a spatial relative risk function using previously collected data.
}
\details{
This function computes the statistical power of the spatial relative risk function (nonparametric estimate of relative risk by kernel smoothing) for previously collected studies with known case and control locations.

The function uses the \code{\link[sparr]{risk}} function to estimate the spatial relative risk function and forces the \code{tolerate} argument to be TRUE in order to calculate asymptotic p-values.

If \code{samp_control = "uniform"} the control locations are randomly generated uniformly within the window of \code{obs_data}. By default, the resolution is an integer value of 128 and can be specified using the \code{resolution} argument in the internally called \code{\link[sparr]{risk}} function.

If \code{samp_control = "CSR"} the control locations are randomly generated assuming complete spatial randomness (homogeneous Poisson process) within the window of \code{obs_data} with a \code{lambda = number of controls / [resolution x resolution]}. By default, the resolution is an integer value of 128 and can be specified using the \code{resolution} argument in the internally called \code{\link[sparr]{risk}} function.

If \code{samp_control = "MVN"} the control locations are randomly generated assuming a multivariate normal distribution \emph{centered at each observed location}. The optional argument \code{s_control} specifies the standard deviation of the multivariate normal distribution (1 by default) in the units of the \code{obs_data}.
}
\examples{
# Using the \code{\link[spatstat.data]{chorley}} dataset
data(chorley)
f1 <- jitter_power(obs_data = unique(chorley),
                   sim_total = 2,
                   samp_control = "MVN",
                   s_control = 0.01,
                   verbose = FALSE
                   )

}
\seealso{
\code{\link[sparr]{risk}} for additional arguments for bandwidth selection, edge correction, and resolution.
}
