% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-generics.R, R/s3-sparsebnPath.R
\docType{class}
\name{sparsebnPath}
\alias{as.sparsebnPath}
\alias{is.sparsebnPath}
\alias{print.sparsebnPath}
\alias{sparsebnPath}
\title{sparsebnPath class}
\usage{
sparsebnPath(x)

as.sparsebnPath(x)

is.sparsebnPath(x)

\method{print}{sparsebnPath}(x, verbose = FALSE, ...)
}
\arguments{
\item{x}{Only used internally.}

\item{verbose}{If \code{TRUE}, then each estimate in the solution path is printed separately. Do not use for
large graphs or large solution paths. (default = \code{FALSE})}

\item{...}{(optional) additional arguments.}
}
\description{
Convenience wrapper class for output of CCDr algorithm: Represents the entire solution path
of the CCDr algorithm. Its components are of type \code{\link{sparsebnFit}}. Also inherits
from \code{\link{list}}.
}
\details{
Each value of lambda in the (discrete) solution path corresponds to a single DAG estimate (see \href{http://jmlr.org/papers/v16/aragam15a.html}{Aragam and Zhou (2015)} for details).
Internally, this estimate is represented by a \code{\link{sparsebnFit}} object. The full solution
path is then represented as a \code{\link{list}} of \code{\link{sparsebnFit}} objects: This class is essentially a wrapper for this list.
}
\section{Methods}{

\code{\link{get.adjacency.matrix}}, \code{\link{lambda.grid}},
\code{\link{num.nodes}}, \code{\link{num.edges}}, \code{\link{num.samples}}
}

