% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsegl-methods.R
\name{coef.sparsegl}
\alias{coef.sparsegl}
\title{Extract model coefficients from a \code{sparsegl} object.}
\usage{
\method{coef}{sparsegl}(object, s = NULL, ...)
}
\arguments{
\item{object}{Fitted \code{\link[=sparsegl]{sparsegl()}} object.}

\item{s}{Value(s) of the penalty parameter \code{lambda} at which
coefficients are required. Default is the entire sequence.}

\item{...}{Not used.}
}
\value{
The coefficients at the requested values for \code{lambda}.
}
\description{
Computes the coefficients at the requested value(s) for \code{lambda} from a
\code{\link[=sparsegl]{sparsegl()}} object.
}
\details{
\code{s} is the new vector of \code{lambda} values at which predictions are requested.
If \code{s} is not in the lambda sequence used for fitting the model, the \code{coef}
function will use linear interpolation to make predictions. The new values
are interpolated using a fraction of coefficients from both left and right
\code{lambda} indices.
}
\examples{
n <- 100
p <- 20
X <- matrix(rnorm(n * p), nrow = n)
eps <- rnorm(n)
beta_star <- c(rep(5, 5), c(5, -5, 2, 0, 0), rep(-5, 5), rep(0, (p - 15)))
y <- X \%*\% beta_star + eps
groups <- rep(1:(p / 5), each = 5)
fit1 <- sparsegl(X, y, group = groups)
coef(fit1, s = c(0.02, 0.03))
}
\seealso{
\code{\link[=sparsegl]{sparsegl()}} and \code{\link[=predict.sparsegl]{predict.sparsegl()}}.
}
