% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateVECM.R
\name{simulateVECM}
\alias{simulateVECM}
\title{VECM simulation}
\usage{
simulateVECM(N = 100, p = 1, nobs = 250, rho = 0.5, sparsity = 0.05,
  method = "normal", covariance = "toeplitz")
}
\arguments{
\item{N}{dimension of the time series.}

\item{p}{number of lags of the VECM model.}

\item{nobs}{number of observations to be generated.}

\item{rho}{base value for the covariance matrix.}

\item{sparsity}{density (in percentage) of the number of nonzero elements of the VAR matrices.}

\item{method}{which method to use to generate the matrices. Possible values
are \code{"normal"} or \code{"bimodal"}.}

\item{covariance}{type of covariance matrix to use in the simulation. Possible 
values: \code{"toeplitz"}, \code{"block1"} or \code{"block2"}.}
}
\value{
A a list of NxN matrices ordered by lag

data a list with two elements: \code{series} the multivariate time series and
\code{noises} the time series of errors

S the variance/covariance matrix of the process
}
\description{
This function generates a simulated multivariate VECM time series.
}

