% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsevb-package.R
\docType{package}
\name{sparsevb-package}
\alias{sparsevb}
\alias{sparsevb-package}
\title{sparsevb: Spike-and-Slab Variational Bayes for Linear and Logistic Regression}
\description{
Implements variational Bayesian algorithms to perform scalable variable selection for sparse, high-dimensional linear and logistic regression models. Features include a novel prioritized updating scheme, which uses a preliminary estimator of the variational means during initialization to generate an updating order prioritizing large, more relevant, coefficients. Sparsity is induced via spike-and-slab priors with either Laplace or Gaussian slabs. By default, the heavier-tailed Laplace density is used. Formal derivations of the algorithms and asymptotic consistency results may be found in Kolyan Ray and Botond Szabo (2020) <doi:10.1080/01621459.2020.1847121> and Kolyan Ray, Botond Szabo, and Gabriel Clara (2020) <arXiv:2010.11665>.
}
\details{
For details as they pertain to using the package, consult the
  \code{\link{svb.fit}} function help page. Detailed descriptions and
  derivations of the variational algorithms with Laplace slabs may be found
  in the references.
}
\references{
\itemize{ \item Ray K. and Szabo B. Variational Bayes for
  high-dimensional linear regression with sparse priors. (2020).
  \emph{Journal of the American Statistical Association}. \item Ray K., Szabo
  B., and Clara G. Spike and slab variational Bayes for high dimensional
  logistic regression. (2020). \emph{Advances in Neural Information
  Processing Systems 33}.}
}
\seealso{
Useful links:
\itemize{
  \item Report bugs at \url{https://gitlab.com/gclara/varpack/-/issues}
}

}
\author{
\strong{Maintainer}: Gabriel Clara \email{gabriel.j.clara@gmail.com}

Authors:
\itemize{
  \item Botond Szabo
  \item Kolyan Ray
}

}
