% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atest_utilities.R
\name{plotATestsFromTimepointFiles}
\alias{plotATestsFromTimepointFiles}
\title{Plots the A-Tests for all timepoints being examined}
\usage{
plotATestsFromTimepointFiles(FILEPATH, PARAMETERS, ATESTRESULTFILENAME,
  ATESTSIGLEVEL, MEASURES, PMIN, PMAX, PINC, TIMEPOINTS)
}
\arguments{
\item{FILEPATH}{Directory where the results of the simulation runs, in folders or in single CSV file format, can be found}

\item{PARAMETERS}{Array containing the names of the parameters of which parameter samples will be generated}

\item{ATESTRESULTFILENAME}{Name of the CSV file containing the A-Test results to be plotted}

\item{ATESTSIGLEVEL}{Value to plot for a large difference between distributions on this plot}

\item{MEASURES}{An array containing the names of the simulation output measures to be analysed.}

\item{PMIN}{Array containing the minimum value that should be used for each parameter.  Sets a lower bound on sampling space}

\item{PMAX}{Array containing the maximum value that should be used for each parameter.  Sets an upper bound on sampling space}

\item{PINC}{Array containing the increment value that should be applied for each parameter. For example, a parameter could have a minimum value of 10, and maximum value of 100, and be incremented by 10}

\item{TIMEPOINTS}{Implemented so this method can be used when analysing multiple simulation timepoints. If only analysing one timepoint, this should be set to NULL. If not, this should be an array of timepoints, e.g. c(12,36,48,60)}
}
\description{
When plotting a time-course analysis, it may be useful to compare results
gained at multiple timepoints, and determine the differences in
performance over time. This function provides a means of plotting those
results
}
