% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bssr.nb.inar1.r
\name{bssr.nb.inar1}
\alias{bssr.nb.inar1}
\title{Blinded Sample Size Reestimation for Longitudinal Count Data using the NB-INAR(1) Model}
\source{
\code{rnbinom.inar1} uses code contributed by Thomas Asendorf.
}
\usage{
bssr.nb.inar1(alpha, power, delta, x, n, k)
}
\arguments{
\item{alpha}{level (type I error) to which the hypothesis is tested.}

\item{power}{power (1 - type II error) to which an alternative should be proven.}

\item{delta}{the rate ratio which is to be proven.}

\item{x}{a matrix or data frame containing count data which is to be fitted. Columns correspond to time points, rows to observations.}

\item{n}{a vector giving the sample size within the control group and the treatment group, respecitvely.}

\item{k}{planned sample size allocation factor between groups: see 'Details'.}
}
\value{
\code{rnbinom.inar1} returns the required sample size within the control group and treatment group.
}
\description{
\code{bssr.nb.inar1} fits blinded observations and recalculates the sample size required for proving a desired alternative when testing for
a rate ratio between two groups unequal to one. See 'Details' for more information.
}
\details{
When testing for differences between rates \eqn{\mu_C} and \eqn{\mu_T} of two groups, a control and a treatment group respectively, we usually
test for the ratio between the two rates, i.e. \eqn{\mu_T/\mu_C = 1}. The ratio of the two rates is refered to as \eqn{\delta}, i.e.
\eqn{\delta = \mu_T/\mu_C}.

\code{bssr.nb.inar1} gives back the required sample size for the control and treatment group required to prove an existing
alternative \code{theta} with a specified power \code{power} when testing the null hypothesis \eqn{H_0: \mu_T/\mu_C \ge 1} to level \code{alpha}.
Nuisance parameters are estimated through the blinded observations \code{x}, thus not further required.

for sample sizes \eqn{n_C} and \eqn{n_T} of the control and treatment group, respectively, the argument \code{k} is the desired
sample size allocation factor at the end of the study, i.e. \eqn{k = n_T/n_C}.
}
\examples{
#Calculate required sample size to find significant difference with
#80\% probability when testing the Nullhypothesis H_0: mu_T/mu_C >= 1
#assuming the true effect delta is 0.8 and rate, size and correlation
#parameter in the control group are 2, 1 and 0.5, respectively.

estimate<-n.nb.inar1(alpha=0.025, power=0.8, delta=0.8, muC=2, size=1, rho=0.5, tp=7, k=1)

#Simulate data
placebo<-rnbinom.inar1(n=50, size=1, mu=2, rho=0.5, tp=7)
treatment<-rnbinom.inar1(n=50, size=1, mu=1.6, rho=0.5, tp=7)

#Blinded sample size reestimation
blinded.data<-rbind(placebo, treatment)[sample(1:100),]
estimate<-bssr.nb.inar1(alpha=0.025, power=0.8, delta=0.8, x=blinded.data, n=c(50,50), k=1)
summary(estimate)
}
\seealso{
\code{\link{rnbinom.inar1}} for information on the NB-INAR(1) model, \code{\link{n.nb.inar1}} for calculating
initial sample size required when performing inference, \code{\link{fit.nb.inar1}} for calculating
initial parameters required when performing sample size estimation
}

