# Notes on the files in the src directory

- files containing functions linked to R begin with an r
- woweights represents "without weights" and describes files and functions without precomputed weights as inputs
- wweights represents "with weights" and describes files and functions with precomputed weights as inputs
- upd marks files targeting the update_rst case
- Rcpp objects are not passed as const, as Rcpp does not enforce const correctness
- one call functions are only targeting undirected graphs, since vertices without outbound edges would always be declared unconnected in a directed graph
- the package uses overloading for polymorphism
- many files contain one function with multiple overloaded versions
- serial executions run the code without OpenMP, not with OpenMP and num_threads(1)
- the paradigm of choice is functional, avoiding object-oriented programming
- functions use structs neither for inputs nor for outputs, to not hide the type of passed data
- a part of the code violates the _Do Not Repeat Yourself_ principle because of (i) computational optimization, (ii) a clean distinction between type combinations, and (iii) an easy modification of individual pipelines without having to dissect broader functions
- future versions may use a combination of overloading and templates for polymorphism
- thread-safe R vectors could increase the efficiency of this package, as some data would not have to be copied to C++ std vectors
- inline functions are exclusively defined in header files

## File dependencies
- r_destination_names
- r_distances_woweights
  - graph_to
  - starts_targets
  - distances_wweights
    - distances_one_call_wweights
      - pair_types
      - target_distances
    - distances_multiple_calls_wweights
      - pair_types
      - targets_set
      - target_distances
        - stat_target_distances
        - upd_target_distances
      - visited
    - show_progress
  - distances_woweights
    - distances_one_call_woweights
      - pair_types
      - target_distances
        - stat_target_distances
        - upd_target_distances
      - individual_distances
    - distances_multiple_calls_woweights
      - pair_types
      - targets_set
      - target_distances
        - stat_target_distances
        - upd_target_distances
      - individual_distances
      - visited
    - show_progress
  - graph_weights
    - coordinates
- r_distances_wweights
  - starts_targets
  - graph_to
  - graph_weights
    - coordinates
  - distances_wweights
    - distances_one_call_wweights
      - pair_types
      - target_distances
    - distances_multiple_calls_wweights
      - pair_types
      - targets_set
      - target_distances
        - stat_target_distances
        - upd_target_distances
      - visited
    - show_progress
- r_paths_woweights
  - starts_targets
  - graph_to
  - graph_weights
    - coordinates
  - paths_wweights
    - paths_one_call_wweights
      - pair_types
      - target_distances
        - stat_target_distances
        - upd_target_distances
      - target_paths
        - stat_target_paths
        - upd_target_paths
    - paths_multiple_calls_wweights
      - pair_types
      - targets_set
      - target_distances
        - stat_target_distances
        - upd_target_distances
      - target_paths
        - stat_target_paths
        - upd_target_paths
      - visited
    - show_progress
  - paths_woweights
    - paths_one_call_woweights
      - pair_types
      - individual_distances
      - target_distances
        - stat_target_distances
        - upd_target_distances
      - target_paths
        - stat_target_paths
        - upd_target_paths
    - paths_multiple_calls_woweights
      - pair_types
      - targets_set
      - individual_distances
      - target_distances
        - stat_target_distances
        - upd_target_distances
      - target_paths
        - stat_target_paths
        - upd_target_paths
      - visited
    - show_progress
  - coordinates
- r_paths_wweights
  - starts_targets
  - graph_to
  - graph_weights
    - coordinates
  - paths_wweights
    - paths_one_call_wweights
      - pair_types
      - target_distances
        - stat_target_distances
        - upd_target_distances
      - target_paths
        - stat_target_paths
        - upd_target_paths
    - paths_multiple_calls_wweights
      - pair_types
      - targets_set
      - target_distances
        - stat_target_distances
        - upd_target_distances
      - target_paths
        - stat_target_paths
        - upd_target_paths
      - visited
    - show_progress
  - coordinates
- r_upd_distances_woweights
  - starts_targets
  - convert_upd_rst
  - graph_to
  - graph_weights
    - coordinates
  - upd_distances_wweights
    - paths_wweights
      - paths_one_call_wweights
        - pair_types
        - target_distances
          - stat_target_distances
          - upd_target_distances
        - target_paths
          - stat_target_paths
          - upd_target_paths
      - paths_multiple_calls_wweights
        - pair_types
        - targets_set
        - target_distances
          - stat_target_distances
          - upd_target_distances
        - target_paths
          - stat_target_paths
          - upd_target_paths
        - visited
      - show_progress
    - upd_affected_paths
    - repeat_distances
    - upd_starts_targets_map
      - upd_starts_targets
    - distances_multiple_calls_wweights
      - pair_types
      - targets_set
      - target_distances
        - stat_target_distances
        - upd_target_distances
      - visited
    - show_progress
  - upd_distances_woweights
    - coordinates
    - paths_woweights
      - paths_one_call_woweights
        - pair_types
        - individual_distances
        - target_distances
          - stat_target_distances
          - upd_target_distances
        - target_paths
          - stat_target_paths
          - upd_target_paths
      - paths_multiple_calls_woweights
        - pair_types
        - targets_set
        - individual_distances
        - target_distances
          - stat_target_distances
          - upd_target_distances
        - target_paths
          - stat_target_paths
          - upd_target_paths
        - visited
      - show_progress
    - upd_affected_paths
    - upd_starts_targets_map
      - upd_starts_targets
    - distances_multiple_calls_woweights
      - pair_types
      - targets_set
      - target_distances
        - stat_target_distances
        - upd_target_distances
      - individual_distances
      - visited
    - repeat_distances
    - show_progress
- r_upd_distances_wweights
  - starts_targets
  - convert_upd_rst
  - graph_to
  - graph_weights
    - coordinates
  - upd_distances_wweights
    - paths_wweights
      - paths_one_call_wweights
        - pair_types
        - target_distances
          - stat_target_distances
          - upd_target_distances
        - target_paths
          - stat_target_paths
          - upd_target_paths
      - paths_multiple_calls_wweights
        - pair_types
        - targets_set
        - target_distances
          - stat_target_distances
          - upd_target_distances
        - target_paths
          - stat_target_paths
          - upd_target_paths
        - visited
      - show_progress
    - upd_affected_paths
    - repeat_distances
    - upd_starts_targets_map
      - upd_starts_targets
    - distances_multiple_calls_wweights
      - pair_types
      - targets_set
      - target_distances
        - stat_target_distances
        - upd_target_distances
      - visited
    - show_progress
- r_upd_paths_woweights
  - starts_targets
  - convert_upd_rst
  - graph_to
  - graph_weights
    - coordinates
  - upd_paths_wweights
    - paths_wweights
      - paths_one_call_wweights
        - pair_types
        - target_distances
          - stat_target_distances
          - upd_target_distances
        - target_paths
          - stat_target_paths
          - upd_target_paths
      - paths_multiple_calls_wweights
        - pair_types
        - targets_set
        - target_distances
          - stat_target_distances
          - upd_target_distances
        - target_paths
          - stat_target_paths
          - upd_target_paths
        - visited
      - show_progress
    - upd_affected_paths
    - upd_starts_targets_map
    - paths_multiple_calls_wweights
      - pair_types
      - targets_set
      - target_distances
        - stat_target_distances
        - upd_target_distances
      - target_paths
        - stat_target_paths
        - upd_target_paths
      - visited
    - repeat_distances
    - show_progress
  - upd_paths_woweights
    - paths_woweights
      - paths_one_call_woweights
        - pair_types
        - individual_distances
        - target_distances
          - stat_target_distances
          - upd_target_distances
        - target_paths
          - stat_target_paths
          - upd_target_paths
      - paths_multiple_calls_woweights
        - pair_types
        - targets_set
        - individual_distances
        - target_distances
          - stat_target_distances
          - upd_target_distances
        - target_paths
          - stat_target_paths
          - upd_target_paths
        - visited
      - show_progress
    - upd_affected_paths
    - upd_starts_targets_map
    - paths_multiple_calls_woweights
      - pair_types
      - targets_set
      - individual_distances
      - target_distances
        - stat_target_distances
        - upd_target_distances
      - target_paths
        - stat_target_paths
        - upd_target_paths
      - visited
    - repeat_distances
    - show_progress
    - coordinates
