% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kde2D.R
\name{kde2D}
\alias{kde2D}
\title{2-dimensional kernel density estimate}
\usage{
kde2D(x, bw = NULL, n = 120, ext = NULL, standardize = FALSE)
}
\arguments{
\item{x}{SpatialPoints of SpatialPointsDataFrame object}

\item{bw}{Bandwidth of Gaussian Kernel}

\item{n}{Number of rows and columns (evaluation points)}

\item{ext}{Extent of raster, coordinates as: c(xmin, xmax, ymin, ymax)}

\item{standardize}{Standardize results to 0-1 (FALSE/TRUE)}
}
\value{
A list object with:

kde        Raster class object of kernel density estimate

bandwidth  Bandwidth of kernel
}
\description{
Calculates kernel density estimate, over specified extent, and outputs a raster
}
\examples{
library(sp)
library(raster)
data(meuse)
coordinates(meuse) <- ~x+y

meuse.kde <- kde2D(meuse, bw = 1000, n = 500, standardize = TRUE)  

plot(meuse.kde$kde)
  plot(meuse, pch=20, cex=0.75, col="red", add=TRUE)				   

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
