% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator_moran.R
\name{indicator_moran}
\alias{indicator_moran}
\title{Moran's Index at lag of 1}
\usage{
indicator_moran(input, subsize = 1, nreplicates = 999)
}
\arguments{
\item{input}{An matrix or a list of matrix object. It should 
be a square matrix}

\item{subsize}{logical. Dimension of the submatrix used to coarse-grain the 
original matrix (set to 1 for no coarse-graining).}

\item{nreplicates}{Number of replicates to produce to estimate null 
distribution of index (default: 999).}
}
\value{
A list (or a list of those if input is a list of matrix 
  object) of:
    \itemize{
      \item `value`: Spatial autocorrelation of the matrix
    }
  If nreplicates is above 2, then the list has the following additional 
  components : 
    \itemize{
      \item `null_mean`: Mean autocorrelation of the null distribution
      \item `null_sd`: SD of autocorrelation in the null distribution
      \item `z_score`: Z-score of the observed value in the null distribution
      \item `pval`: p-value based on the rank of the observed autocorrelation
                      in the null distribution.
    }
}
\description{
This functions computes the Moran's spatial correlation index 
  (with lag one). It also computes a null value obtained by randomizing 
  the matrix.
}
\examples{

\dontrun{
data(serengeti)

# One matrix
indicator_moran(serengeti[1])

# Several matrices
indicator_moran(serengeti)
}

}
\references{
Dakos, V., van Nes, E. H., Donangelo, R., Fort, H., & 
Scheffer, M. (2010). Spatial correlation as leading indicator of 
catastrophic shifts. Theoretical Ecology, 3(3), 163-174.

Legendre, P., & Legendre, L. F. J. (2012). Numerical Ecology.
Elsevier Science.
}
