% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indicator_sdr.R
\name{indicator_sdr}
\alias{indicator_sdr}
\title{Spectral Density Ratio (SDR) indicator}
\usage{
indicator_sdr(input, sdr_low_range = NULL, sdr_high_range = NULL,
  nreplicates = 999)
}
\arguments{
\item{input}{A matrix or a logical matrix (TRUE/FALSE), or a list of these.}

\item{sdr_low_range}{The range of values (in proportion) to 
use for the computation of the spectral density ratio.
For example, for the lowest 20\% (default value), set \code{sdr_low_range}
to \code{c(0, .2)}.}

\item{sdr_high_range}{The range of values (in proportion) to 
use for the computation of the spectral density ratio. For example, for 
the highest 20\% (default value), set \code{sdr_high_range} to 
\code{c(.8, 1)}.}

\item{nreplicates}{The number of replicates to compute for the null 
distribution}
}
\value{
A list (or a list of lists if input was a list of matrices) with 
  components:
    \itemize{
      \item `value`: SDR of the matrix
    }
  If nreplicates is above 2, then the list has the following additional 
  components : 
    \itemize{
      \item `null_mean`: Mean SDR of the null distribution
      \item `null_sd`: SD of SDR in the null distribution
      \item `z_score`: Z-score of the observed value in the null distribution 
                         (value minus the null mean and divided by null 
                         standard deviation)
      \item `pval`: p-value based on the rank of the observed SDR
                      in the null distribution. A low p-value means that 
                      the indicator value is significantly higher than the 
                      null values. 
    }
}
\description{
Compute the ratio of low frequencies over high frequencies
  of the r-spectrum. It also computes a null value obtained by 
  randomizing the matrix.
}
\details{
SDR measures the increase in long-range correlations before a critical point. 
  It is the ratio of the average low frequency value over high frequency 
  values. In this implementation, an increase in SDR implies a "reddening" 
  of the \link[=rspectrum]{r-spectrum}. See also \code{\link{spectral_sews}} for 
  a more complete description. 

Low and high frequencies are averaged in order to compute the SDR. The 
  parameters \code{sdr_low_range} and \code{sdr_high_range} control which 
  frequencies are selected for averaging. For example 
  \code{sdr_low_range = c(0, .2)} (default) uses the lower 20% to compute 
  the average of low frequencies. \code{sdr_high_range = c(.8, 1)} uses the 
  higher 20% for the average of high frequencies.
}
\examples{

\dontrun{ 
serengeti.sdr <- indicator_sdr(serengeti, nreplicates = 499)
do.call(rbind, serengeti.sdr) # convert results to data.frame
}

}
\references{
Carpenter, S.R. & Brock, W.A. (2010). Early warnings of regime shifts in 
  spatial dynamics using the discrete Fourier transform. Ecosphere
}
\seealso{
spectral_sews, rspectrum
}
