% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_generic_indic.R,
%   R/task_generic_indic_indictest.R, R/task_generic_indic_indictest_methods.R,
%   R/task_generic_indic_methods.R
\name{generic_sews}
\alias{generic_sews}
\alias{indictest.generic_sews}
\alias{plot.generic_sews_test}
\alias{plot.generic_sews}
\title{Generic Spatial Early-Warning signals}
\usage{
generic_sews(mat, subsize = 4, abs_skewness = FALSE,
  moranI_coarse_grain = FALSE)

\method{indictest}{generic_sews}(x, nperm = 999, ...)

\method{plot}{generic_sews_test}(x, along = NULL, what = "value",
  display_null = TRUE, ...)

\method{plot}{generic_sews}(x, along = NULL, ...)
}
\arguments{
\item{mat}{A matrix (quantitative data), a binary matrix (TRUE/FALSE data), 
or a list of those}

\item{subsize}{The subsize used for the coarse-graining phase (see Details)}

\item{abs_skewness}{Should the absolute skewness be used instead of its 
raw values ?}

\item{moranI_coarse_grain}{Should the input matrix be coarse-grained before
computing the Moran's I indicator value ?}

\item{x}{A \code{generic_sews} object (as provided by the 
\code{generic_sews} function).}

\item{nperm}{The number of replicates to use to compute a null 
distribution}

\item{...}{Additional arguments passed onto methods}

\item{along}{A vector providing values over which the indicator trend 
will be plotted. If \code{NULL} then the values are plotted sequentially 
in their original order.}

\item{what}{The trendline to be displayed. Defaults to the indicator's 
values ("value") but other metrics can be displayed. Correct values are 
"value", "pval" or "z_score".}

\item{display_null}{Chooses whether a grey ribbon should be added to reflect
the null distribution. Note that it can not be displayed when the trend 
line reflects something else than the indicator values (when \code{what} 
is not set to "value").}
}
\value{
\code{generic_sews} returns an object of class \code{generic_sews_single}
  (actually a list) if mat is a single matrix or an object of class 
  \code{generic_sews_list} if mat is a list. 

\code{indictest} returns an object of class \code{generic_test} (actually 
  a data.frame). 

\code{plot} methods return ggplot objects, usually immediately displayed 
  when used interactively.
}
\description{
Computation, significance assessment and display of spatial 
  generic early warning signals (Moran's I, variance and skewness)
}
\details{
The Generic Early warning signal are based on the property of a 
  dynamical system to "slow down" when approaching a critical point, 
  that is take more time to return to equilibrium after a perturbation. This 
  is expected to be reflected in several spatial characteristics: the 
  variance, the spatial autocorrelation (at lag-1) and the skewness. This 
  function provides a convenient workflow to compute these indicators, 
  assess their significance and display the results. 

Before computing the actual indicators, the matrix can be "coarse-grained". 
  This process reduces the matrix by averaging the nearby cells using 
  a square window defined by the \code{subsize} parameter. This makes spatial  
  variance and skewness reflect actual spatial patterns when working with 
  binary (\code{TRUE}/\code{FALSE} data), but is optional when using 
  continuous data. Keep in mind that it effectively reduces the size of 
  the matrix by approximately \code{subsize} on each dimension. 
  
The significance of generic early-warning signals can be estimated by 
  reshuffling the original matrix (function \code{indictest}). Indicators 
  are then recomputed on the shuffled matrices and the values obtained are 
  used as a null distribution. P-values are obtained based on the rank of 
  the observed value in the null distribution. A small P-value means 
  that the indicator is significantly above the null values, as expected 
  before a critical point. 

The \code{plot} method can displays the results graphically. A text summary 
  can be obtained using the \code{summary} method.

Note that the produced plot is adjusted depending on whether 
  \code{along} is numeric or not.
}
\examples{

data(serengeti)
gen_indic <- generic_sews(serengeti, subsize = 5, 
                           moranI_coarse_grain = TRUE)

# Display results
summary(gen_indic)

# Display trends along the varying model parameter
plot(gen_indic, along = serengeti.rain)

# Compute significance (long)
\dontrun{
gen_test <- indictest(gen_indic, nperm = 199)

print(gen_test)

# Display the trend, now with a grey ribbon indicating the 5\%-95\% quantile
# range of the null distribution
plot(gen_test, along = serengeti.rain)

# Display the effect size compared to null distribution 
plot(gen_test, along = serengeti.rain, what = "z_score")

# Note that plot() method returns a ggplot object that can be modified
# for convenience
if ( require(ggplot2) ) { 
  plot(gen_test, along = serengeti.rain) + 
    geom_vline(xintercept = 733, color = "red", linetype = "dashed") +
    xlab('Annual rainfall') + 
    theme_minimal()
}

}

}
\references{
Kefi, S., Guttal, V., Brock, W.A., Carpenter, S.R., Ellison, A.M., 
  Livina, V.N., et al. (2014). Early Warning Signals of Ecological 
  Transitions: Methods for Spatial Patterns. PLoS ONE, 9, e92097.
  
  Dakos, V., van Nes, E. H., Donangelo, R., Fort, H., & 
  Scheffer, M. (2010). Spatial correlation as leading indicator of 
  catastrophic shifts. Theoretical Ecology, 3(3), 163-174.
  
  Guttal, V., & Jayaprakash, C. (2008). Spatial variance and spatial 
  skewness: leading indicators of regime shifts in spatial ecological 
  systems. Theoretical Ecology, 2(1), 3-12.
}
\seealso{
\code{\link{indicator_moran}}, \code{\link{indicator_variance}} and 
  \code{\link{indicator_skewness}} for individual indicators.
}
