% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{dda}
\alias{dda}
\alias{dda.pars}
\title{Density-dependent aggregation model}
\format{
An object of class \code{list} of length 4.

An object of class \code{data.frame} with 4 rows and 5 columns.
}
\source{
Kindly provided by Koen Siteur
}
\usage{
dda

dda.pars
}
\description{
\code{dda} is a list of matrices representing results from the 
  density-dependent aggregation model (Siteur et al. 2023) in \code{dda}.
  \code{dda.pars} is a data frame with the model parameters. Each row of
  \code{dda.pars} corresponds to a matrix in \code{dda}, in the same order. All
  parameters were maintained constant, except for tau (see model
  definition in Siteur et al. 2023).
}
\examples{

ddasews <- lsw_sews(dda)
plot(ddasews, along = dda.pars[ ,"tau"]) # tau is the changing parameter

display_matrix(dda[[4]]) 

}
\references{
Siteur, Koen, Quan-Xing Liu, Vivi Rottschäfer, Tjisse van der Heide, Max Rietkerk,
  Arjen Doelman, Christoffer Boström, and Johan van de Koppel. 2023. "Phase-Separation
   Physics Underlies New Theory for the Resilience of Patchy Ecosystems." Proceedings 
   of the National Academy of Sciences 120 (2): e2202683120. 
   https://doi.org/10.1073/pnas.2202683120.
}
\keyword{datasets}
