% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_polys.R
\name{group_polys}
\alias{group_polys}
\title{Group Polygons}
\usage{
group_polys(DT = NULL, area = NULL, hrType = NULL, hrParams = NULL,
  projection = NULL, id = NULL, coords = NULL, splitBy = NULL,
  spPolys = NULL)
}
\arguments{
\item{DT}{input data.table}

\item{area}{boolean indicating either returning area and proportion of overlap or group}

\item{hrType}{type of HR estimation, of 'mcp' or 'kernel'}

\item{hrParams}{parameters for adehabitatHR functions, a named list passed to do.call}

\item{projection}{PROJ.4 character string}

\item{id}{Character string of ID column name}

\item{coords}{Character vector of X coordinate and Y coordinate column names}

\item{splitBy}{(optional) character string or vector of grouping field(s) upon which the grouping will be calculated}

\item{spPolys}{Alternatively, provide solely a SpatialPolygons object.}
}
\value{
If area is FALSE, a DT is returned with ID and spatialtemporal group. If area is TRUE, a DT is returned with ID and a proportional overlap. ID refers to the focal individual of which the total area is compared against the overlapping area of ID2.
}
\description{
Group individuals by polygon (eg: home ranges) overlap
}
\examples{
library(data.table)
DT <- fread(system.file("extdata", "DT.csv", package = "spatsoc"))

utm <- '+proj=utm +zone=36 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs'

group_polys(DT, area = FALSE, 'mcp', list(percent = 95),
            projection = utm,
            id = 'ID', coords = c('X', 'Y'))

areaDT <- group_polys(DT, area = TRUE, 'mcp', list(percent = 95),
                      projection = utm,
                      id = 'ID', coords = c('X', 'Y'))
}
