% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HaltonFrames.R
\name{HaltonFrameBase}
\alias{HaltonFrameBase}
\title{Generate a Halton Frame.}
\usage{
HaltonFrameBase(
  n = (bases[1]^J[1]) * (bases[2]^J[2]),
  J = base::c(3, 2),
  bases = base::c(2, 3),
  seeds = NULL
)
}
\arguments{
\item{n}{The number of points in the frame to generate.}

\item{J}{The number of grid cells. A list of 2 values. The default value is c(3, 2), we could also use c(5, 3).}

\item{bases}{Co-prime base for the Halton Sequence. The default value is c(2, 3).}

\item{seeds}{The u1 and u2 seeds to use.}
}
\value{
A list containing the following four variables:
halton_seq -
halton_seq_div -
Z -
halton_frame -
}
\description{
A description of this useful function.
}
\details{
This function was written by Phil Davies.
}
\keyword{internal}
