% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuildFeatureMatrix.R
\name{BuildFeatureMatrix}
\alias{BuildFeatureMatrix}
\title{Build a Feature matrix from the with speaq 2.0 processed data}
\usage{
BuildFeatureMatrix(Y.data, var = "peakValue", impute = "zero",
  delete.below.threshold = FALSE, baselineThresh = 500, snrThres = 3,
  thresholds.pass = "any-to-pass")
}
\arguments{
\item{Y.data}{The dataset after (at least) peak detection and alignment with speaq 2.0.}

\item{var}{The variable to be used in the Featurematrix. This can be any of 'peakIndex', 'peakPPM', 'peakValue' (default), 'peakSNR', 'peakScale', or 'Sample'.}

\item{impute}{What to impute when a certain peak is missing for a certain sample and feature combo. Options are 'zero' (or 'zeros'), any other statement will produce NA's.}

\item{delete.below.threshold}{Whether to ignore peaks for which the 'var' variable has a value below 'baselineThresh' (default = FALSE).}

\item{baselineThresh}{The threshold for the 'var' variable peaks have to surpass to be included in the feature matrix.}

\item{snrThres}{The threshold for the signal-to-noise ratio of a peak.}

\item{thresholds.pass}{This variable lets users deside whether a peak has to pass all the thresholds (both snrThres and baselineThresh), or just one. (If the peak does not need to surpass any thresholds set 'delete.below.threshold' to FALSE).}
}
\value{
a matrix, data.matrix, with samples for rows and features for columns. The values in the matrix are thoes of the 'var' variable.
}
\description{
This function converts the aligned peak data (so at least pake detection and alignment/grouping has to be completed)
to a matrix with features (aligned peaks) in the columns and the value of that peak for every sample in the rows.
}
\examples{
\dontrun{
# 'DetectedPeaks_aligned' is the peak data after wavelet based peak detection and alignment
Featurematrix <- BuildFeatureMatrix(Y.data = DetectedPeaks_aligned, var = 'peakValue')
}
}
\author{
Charlie Beirnaert, \email{charlie.beirnaert@uantwerpen.be}
}

