/*
 * Decompiled with CFR 0.152.
 */
package at.ac.ait.speedr.importwizard;

import at.ac.ait.speedr.importwizard.WizardPanel;
import at.ac.ait.speedr.importwizard.steps.CSVDataImportWizardStep;
import at.ac.ait.speedr.importwizard.steps.CalcDataImportWizardStep;
import at.ac.ait.speedr.importwizard.steps.DataImportPanel;
import at.ac.ait.speedr.importwizard.steps.DataImportPanelUserActionListener;
import at.ac.ait.speedr.importwizard.steps.DataSourceWizardStep;
import at.ac.ait.speedr.importwizard.steps.ExcelDataImportWizardStep;
import at.ac.ait.speedr.workspace.RUtil;
import at.ac.arcs.tablefilter.ARCTable;
import at.ac.arcs.tablefilter.events.FilterListener;
import java.beans.PropertyChangeListener;
import java.util.NoSuchElementException;
import org.rosuda.REngine.REXPGenericVector;

public class WizardIterator {
    private int index;
    private final String[] steps = new String[]{"Select data", "Edit table"};
    private DataSourceWizardStep dataSourceStep;
    private CSVDataImportWizardStep csvStep;
    private ExcelDataImportWizardStep excelStep;
    private CalcDataImportWizardStep calcStep;
    private WizardPanel settings;
    private DataImportPanelUserActionListener useractionlistener;
    private FilterListener filterlistener;

    public WizardPanel.Step current() {
        if (this.index == 0) {
            if (this.dataSourceStep == null) {
                this.dataSourceStep = new DataSourceWizardStep();
            }
            return this.dataSourceStep;
        }
        String dataFileExtension = (String)this.settings.getProperty("PROP_EXTENSION");
        if (dataFileExtension.equalsIgnoreCase("xls") || dataFileExtension.equalsIgnoreCase("xlsx")) {
            if (this.excelStep == null) {
                this.excelStep = new ExcelDataImportWizardStep();
                if (this.useractionlistener != null) {
                    this.excelStep.getComponent().setUseractionlistener(this.useractionlistener);
                }
                if (this.filterlistener != null) {
                    this.excelStep.getComponent().setFilterListener(this.filterlistener);
                }
            }
            return this.excelStep;
        }
        if (dataFileExtension.equalsIgnoreCase("ods")) {
            if (this.calcStep == null) {
                this.calcStep = new CalcDataImportWizardStep();
                if (this.useractionlistener != null) {
                    this.calcStep.getComponent().setUseractionlistener(this.useractionlistener);
                }
                if (this.filterlistener != null) {
                    this.calcStep.getComponent().setFilterListener(this.filterlistener);
                }
            }
            return this.calcStep;
        }
        if (this.csvStep == null) {
            this.csvStep = new CSVDataImportWizardStep();
            if (this.useractionlistener != null) {
                this.csvStep.getComponent().setUseractionlistener(this.useractionlistener);
            }
            if (this.filterlistener != null) {
                this.csvStep.getComponent().setFilterListener(this.filterlistener);
            }
        }
        return this.csvStep;
    }

    public String name() {
        return this.steps[this.index];
    }

    public boolean hasNext() {
        return this.index < 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextStep() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public REXPGenericVector instantiate() {
        System.gc();
        ARCTable arctable = ((DataImportPanel)this.current().getComponent()).getARCTable();
        return RUtil.createRDataFrame(arctable);
    }

    public void initialize(WizardPanel settings) {
        this.settings = settings;
    }

    public void uninitialize(WizardPanel settings) {
        if (this.settings != null) {
            if (this.current().getComponent() instanceof DataImportPanel) {
                DataImportPanel p = (DataImportPanel)this.current().getComponent();
                p.removePropertyChangeListener((PropertyChangeListener)((Object)this.current()));
                p.setTableModelToNull();
            }
            this.settings = null;
            this.useractionlistener = null;
            this.filterlistener = null;
        }
    }

    public void setDataImportPanelUserActionListener(DataImportPanelUserActionListener useractionlistener) {
        this.useractionlistener = useractionlistener;
    }

    public void setDataImportTableFilterListener(FilterListener listener) {
        this.filterlistener = listener;
    }
}

