/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.split;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockUI;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.action.ListeningDockAction;
import bibliothek.gui.dock.action.actions.GroupedButtonDockAction;
import bibliothek.gui.dock.event.IconManagerListener;
import bibliothek.gui.dock.event.SplitDockListener;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.PropertyValue;
import javax.swing.Icon;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitFullScreenAction
extends GroupedButtonDockAction<Boolean>
implements ListeningDockAction {
    private SplitDockStation split;
    private DockController controller;
    private Listener listener = new Listener();
    private PropertyValue<KeyStroke> accelerator = new PropertyValue<KeyStroke>(SplitDockStation.MAXIMIZE_ACCELERATOR){

        @Override
        protected void valueChanged(KeyStroke keyStroke, KeyStroke keyStroke2) {
            SplitFullScreenAction.this.setAccelerator(Boolean.TRUE, keyStroke2);
            SplitFullScreenAction.this.setAccelerator(Boolean.FALSE, keyStroke2);
        }
    };

    public SplitFullScreenAction(SplitDockStation splitDockStation) {
        super(null);
        this.split = splitDockStation;
        this.setRemoveEmptyGroups(false);
        splitDockStation.addSplitDockStationListener(new SplitDockListener(){

            public void fullScreenDockableChanged(SplitDockStation splitDockStation, Dockable dockable, Dockable dockable2) {
                if (dockable != null) {
                    SplitFullScreenAction.this.change(dockable, Boolean.FALSE);
                }
                if (dockable2 != null) {
                    SplitFullScreenAction.this.change(dockable2, Boolean.TRUE);
                }
            }
        });
        this.setText(Boolean.TRUE, DockUI.getDefaultDockUI().getString("split.normalize"));
        this.setText(Boolean.FALSE, DockUI.getDefaultDockUI().getString("split.maximize"));
        this.setTooltip(Boolean.TRUE, DockUI.getDefaultDockUI().getString("split.normalize.tooltip"));
        this.setTooltip(Boolean.FALSE, DockUI.getDefaultDockUI().getString("split.maximize.tooltip"));
    }

    @Override
    public void setController(DockController dockController) {
        if (this.controller != dockController) {
            if (this.controller != null) {
                this.controller.getIcons().remove("split.normalize", this.listener);
                this.controller.getIcons().remove("split.maximize", this.listener);
            }
            this.controller = dockController;
            this.accelerator.setProperties(dockController);
            if (dockController != null) {
                IconManager iconManager = dockController.getIcons();
                iconManager.add("split.normalize", this.listener);
                iconManager.add("split.maximize", this.listener);
                this.setIcon(true, iconManager.getIcon("split.normalize"));
                this.setIcon(false, iconManager.getIcon("split.maximize"));
            }
        }
    }

    @Override
    public void action(Dockable dockable) {
        DockElement dockElement;
        while (dockable.getDockParent() != this.split) {
            dockElement = dockable.getDockParent();
            if (dockElement == null) {
                return;
            }
            dockable = dockElement.asDockable();
            if (dockable != null) continue;
            return;
        }
        dockElement = this.split.getFullScreen();
        if (dockElement == dockable) {
            this.split.setFullScreen(null);
        } else {
            this.split.setFullScreen(dockable);
        }
    }

    private void change(Dockable dockable, Boolean bl) {
        DockStation dockStation;
        if (this.isKnown(dockable)) {
            this.setGroup(bl, dockable);
        }
        if ((dockStation = dockable.asDockStation()) != null) {
            int n = dockStation.getDockableCount();
            for (int i = 0; i < n; ++i) {
                this.change(dockStation.getDockable(i), bl);
            }
        }
    }

    @Override
    protected Boolean createGroupKey(Dockable dockable) {
        while (dockable.getDockParent() != this.split) {
            DockStation dockStation = dockable.getDockParent();
            if (dockStation == null) {
                return Boolean.FALSE;
            }
            dockable = dockStation.asDockable();
            if (dockable != null) continue;
            return Boolean.FALSE;
        }
        if (dockable == this.split.getFullScreen()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private class Listener
    implements IconManagerListener {
        private Listener() {
        }

        public void iconChanged(String string, Icon icon) {
            if (string.equals("split.normalize")) {
                SplitFullScreenAction.this.setIcon(true, icon);
            } else {
                SplitFullScreenAction.this.setIcon(false, icon);
            }
        }
    }
}

