/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.util;

import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.gui.dock.util.WindowProviderListener;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;

public class WindowProviderWrapper
implements WindowProvider {
    private WindowProvider delegate;
    private List<WindowProviderListener> listeners = new ArrayList<WindowProviderListener>();
    private WindowProviderListener listener = new WindowProviderListener(){

        public void windowChanged(WindowProvider windowProvider, Window window) {
            WindowProviderWrapper.this.fireWindowChanged(window);
        }

        public void visibilityChanged(WindowProvider windowProvider, boolean bl) {
            WindowProviderWrapper.this.fireVisibilityChanged(bl);
        }
    };

    public void addWindowProviderListener(WindowProviderListener windowProviderListener) {
        int n = this.listeners.size();
        this.listeners.add(windowProviderListener);
        if (n == 0 && this.listeners.size() > 0 && this.delegate != null) {
            this.delegate.addWindowProviderListener(this.listener);
        }
    }

    public void removeWindowProviderListener(WindowProviderListener windowProviderListener) {
        int n = this.listeners.size();
        this.listeners.remove(windowProviderListener);
        if (n > 0 && this.listeners.size() == 0 && this.delegate != null) {
            this.delegate.removeWindowProviderListener(this.listener);
        }
    }

    protected WindowProviderListener[] listeners() {
        return this.listeners.toArray(new WindowProviderListener[this.listeners.size()]);
    }

    protected void fireWindowChanged(Window window) {
        for (WindowProviderListener windowProviderListener : this.listeners()) {
            windowProviderListener.windowChanged(this, window);
        }
    }

    protected void fireVisibilityChanged(boolean bl) {
        for (WindowProviderListener windowProviderListener : this.listeners()) {
            windowProviderListener.visibilityChanged(this, bl);
        }
    }

    public void setDelegate(WindowProvider windowProvider) {
        if (this.listeners.size() == 0) {
            this.delegate = windowProvider;
        } else {
            Window window = this.searchWindow();
            boolean bl = this.isShowing();
            if (this.delegate != null) {
                this.delegate.removeWindowProviderListener(this.listener);
            }
            this.delegate = windowProvider;
            if (this.delegate != null) {
                this.delegate.addWindowProviderListener(this.listener);
            }
            Window window2 = this.searchWindow();
            boolean bl2 = this.isShowing();
            if (window != window2) {
                this.fireWindowChanged(window2);
            }
            if (bl != bl2) {
                this.fireVisibilityChanged(bl2);
            }
        }
    }

    public WindowProvider getDelegate() {
        return this.delegate;
    }

    public Window searchWindow() {
        if (this.delegate == null) {
            return null;
        }
        return this.delegate.searchWindow();
    }

    public boolean isShowing() {
        if (this.delegate == null) {
            return false;
        }
        return this.delegate.isShowing();
    }
}

