/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.theme;

import bibliothek.extension.gui.dock.theme.BubbleTheme;
import bibliothek.gui.DockController;
import bibliothek.gui.dock.action.view.ActionViewConverter;
import bibliothek.gui.dock.action.view.ViewTarget;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.action.CPanelPopup;
import bibliothek.gui.dock.common.intern.action.panel.BubblePanelPopupGenerator;
import bibliothek.gui.dock.common.intern.action.panel.PanelDropDownGenerator;
import bibliothek.gui.dock.common.intern.action.panel.PanelMenuGenerator;
import bibliothek.gui.dock.common.intern.color.BubbleButtonTitleTransmitter;
import bibliothek.gui.dock.common.intern.color.BubbleDisplayerTransmitter;
import bibliothek.gui.dock.common.intern.color.BubbleTabTransmitter;
import bibliothek.gui.dock.common.intern.color.BubbleTitleTransmitter;
import bibliothek.gui.dock.common.theme.CDockTheme;
import bibliothek.gui.dock.themes.ColorBridgeFactory;
import bibliothek.gui.dock.themes.NoStackTheme;
import bibliothek.gui.dock.themes.color.DisplayerColor;
import bibliothek.gui.dock.themes.color.TabColor;
import bibliothek.gui.dock.themes.color.TitleColor;
import bibliothek.gui.dock.util.DockUtilities;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.ColorManager;
import java.util.Map;
import javax.swing.Icon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CBubbleTheme
extends CDockTheme<BubbleTheme> {
    public CBubbleTheme(CControl cControl, BubbleTheme bubbleTheme) {
        super(bubbleTheme);
        this.init(cControl);
    }

    public CBubbleTheme(CControl cControl) {
        this(new BubbleTheme());
        this.init(cControl);
    }

    private CBubbleTheme(BubbleTheme bubbleTheme) {
        super(bubbleTheme, new NoStackTheme(bubbleTheme));
    }

    private void init(final CControl cControl) {
        this.putColorBridgeFactory(TabColor.KIND_TAB_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager colorManager) {
                BubbleTabTransmitter bubbleTabTransmitter = new BubbleTabTransmitter(colorManager);
                bubbleTabTransmitter.setControl(cControl);
                return bubbleTabTransmitter;
            }
        });
        this.putColorBridgeFactory(TitleColor.KIND_TITLE_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager colorManager) {
                BubbleTitleTransmitter bubbleTitleTransmitter = new BubbleTitleTransmitter(colorManager);
                bubbleTitleTransmitter.setControl(cControl);
                return bubbleTitleTransmitter;
            }
        });
        this.putColorBridgeFactory(DisplayerColor.KIND_DISPLAYER_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager colorManager) {
                BubbleDisplayerTransmitter bubbleDisplayerTransmitter = new BubbleDisplayerTransmitter(colorManager);
                bubbleDisplayerTransmitter.setControl(cControl);
                return bubbleDisplayerTransmitter;
            }
        });
        this.putColorBridgeFactory(TitleColor.KIND_FLAP_BUTTON_COLOR, new ColorBridgeFactory(){

            public ColorBridge create(ColorManager colorManager) {
                BubbleButtonTitleTransmitter bubbleButtonTitleTransmitter = new BubbleButtonTitleTransmitter(colorManager);
                bubbleButtonTitleTransmitter.setControl(cControl);
                return bubbleButtonTitleTransmitter;
            }
        });
        this.initDefaultFontBridges(cControl);
    }

    @Override
    public void install(DockController dockController) {
        super.install(dockController);
        IconManager iconManager = dockController.getIcons();
        Map<String, Icon> map = DockUtilities.loadIcons("data/bibliothek/gui/dock/icons/bubble/icons.ini", "data/bibliothek/gui/dock/icons/bubble/", CBubbleTheme.class.getClassLoader());
        for (Map.Entry<String, Icon> entry : map.entrySet()) {
            iconManager.setIconTheme(entry.getKey(), entry.getValue());
        }
        ActionViewConverter actionViewConverter = dockController.getActionViewConverter();
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.TITLE, new BubblePanelPopupGenerator());
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.MENU, new PanelMenuGenerator());
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.DROP_DOWN, new PanelDropDownGenerator());
    }

    @Override
    public void uninstall(DockController dockController) {
        super.uninstall(dockController);
        dockController.getIcons().clearThemeIcons();
        ActionViewConverter actionViewConverter = dockController.getActionViewConverter();
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.TITLE, null);
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.MENU, null);
        actionViewConverter.putTheme(CPanelPopup.PANEL_POPUP, ViewTarget.DROP_DOWN, null);
    }
}

