/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.theme.eclipse;

import bibliothek.extension.gui.dock.theme.eclipse.DefaultEclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnectorListener;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;

public class CommonEclipseThemeConnector
extends DefaultEclipseThemeConnector {
    private CControl control;
    private boolean listening = false;
    private CDockablePropertyListener propertyListener = new CDockableAdapter(){

        public void singleTabShownChanged(CDockable cDockable) {
            this.fire(cDockable);
        }

        public void titleShownChanged(CDockable cDockable) {
            this.fire(cDockable);
        }

        private void fire(CDockable cDockable) {
            CommonDockable commonDockable = cDockable.intern();
            EclipseThemeConnector.TitleBar titleBar = CommonEclipseThemeConnector.this.getTitleBarKind(commonDockable);
            for (EclipseThemeConnectorListener eclipseThemeConnectorListener : CommonEclipseThemeConnector.this.listeners()) {
                eclipseThemeConnectorListener.titleBarChanged(CommonEclipseThemeConnector.this, commonDockable, titleBar);
            }
        }
    };

    public CommonEclipseThemeConnector(CControl cControl) {
        this.control = cControl;
    }

    public void addEclipseThemeConnectorListener(EclipseThemeConnectorListener eclipseThemeConnectorListener) {
        super.addEclipseThemeConnectorListener(eclipseThemeConnectorListener);
        this.updateListening();
    }

    public void removeEclipseThemeConnectorListener(EclipseThemeConnectorListener eclipseThemeConnectorListener) {
        super.removeEclipseThemeConnectorListener(eclipseThemeConnectorListener);
        this.updateListening();
    }

    private void updateListening() {
        if (this.hasListeners()) {
            if (!this.listening) {
                this.listening = true;
                this.control.addPropertyListener(this.propertyListener);
            }
        } else if (this.listening) {
            this.listening = false;
            this.control.removePropertyListener(this.propertyListener);
        }
    }

    public EclipseThemeConnector.TitleBar getTitleBarKind(Dockable dockable) {
        boolean bl;
        boolean bl2;
        if (dockable.getDockParent() instanceof StackDockStation) {
            return EclipseThemeConnector.TitleBar.NONE;
        }
        if (dockable instanceof CommonDockable && !(bl2 = ((CommonDockable)dockable).getDockable().isTitleShown()) && !(bl = ((CommonDockable)dockable).getDockable().isSingleTabShown())) {
            return EclipseThemeConnector.TitleBar.NONE_HINTED_BORDERED;
        }
        return super.getTitleBarKind(dockable);
    }
}

