/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.mode;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.event.DockHierarchyEvent;
import bibliothek.gui.dock.event.DockHierarchyListener;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockRelocatorAdapter;
import bibliothek.gui.dock.event.DoubleClickListener;
import bibliothek.gui.dock.facile.mode.DoubleClickLocationStrategy;
import bibliothek.gui.dock.facile.mode.Location;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeListener;
import bibliothek.gui.dock.facile.mode.status.DefaultExtendedModeEnablement;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablement;
import bibliothek.gui.dock.facile.mode.status.ExtendedModeEnablementFactory;
import bibliothek.gui.dock.support.mode.Mode;
import bibliothek.gui.dock.support.mode.ModeManager;
import bibliothek.gui.dock.support.mode.ModeManagerListener;
import bibliothek.gui.dock.util.DockProperties;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.PropertyValue;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.util.Path;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationModeManager<M extends LocationMode>
extends ModeManager<Location, M> {
    public static final PropertyKey<ExtendedModeEnablementFactory> MODE_ENABLEMENT = new PropertyKey<ExtendedModeEnablementFactory>("locationmodemanager.mode_enablement", new ConstantPropertyFactory<ExtendedModeEnablementFactory>(DefaultExtendedModeEnablement.FACTORY), true);
    public static final PropertyKey<DoubleClickLocationStrategy> DOUBLE_CLICK_STRATEGY = new PropertyKey<DoubleClickLocationStrategy>("locationmodemanager.double_click_strategy", new ConstantPropertyFactory<DoubleClickLocationStrategy>(DoubleClickLocationStrategy.DEFAULT), true);
    private Map<Path, List<LocationModeListener>> listeners = new HashMap<Path, List<LocationModeListener>>();
    private RegisterListener registerListener = new RegisterListener();
    private HierarchyListener hierarchyListener = new HierarchyListener();
    private RelocatorListener relocatorListener = new RelocatorListener();
    private PropertyValue<ExtendedModeEnablementFactory> extendedModeFactory = new PropertyValue<ExtendedModeEnablementFactory>(MODE_ENABLEMENT){

        @Override
        protected void valueChanged(ExtendedModeEnablementFactory extendedModeEnablementFactory, ExtendedModeEnablementFactory extendedModeEnablementFactory2) {
            LocationModeManager.this.updateEnablement();
        }
    };
    private PropertyValue<DoubleClickLocationStrategy> doubleClickStrategy = new PropertyValue<DoubleClickLocationStrategy>(DOUBLE_CLICK_STRATEGY){

        @Override
        protected void valueChanged(DoubleClickLocationStrategy doubleClickLocationStrategy, DoubleClickLocationStrategy doubleClickLocationStrategy2) {
        }
    };
    private DoubleClickListener doubleClickListener = new DoubleClickListener(){

        public DockElement getTreeLocation() {
            return null;
        }

        public boolean process(Dockable dockable, MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return false;
            }
            if ((dockable = LocationModeManager.this.getDoubleClickTarget(dockable)) != null) {
                Mode mode = LocationModeManager.this.getCurrentMode(dockable);
                ExtendedMode extendedMode = LocationModeManager.this.getDoubleClickStrategy().handleDoubleClick(dockable, mode == null ? null : mode.getExtendedMode(), LocationModeManager.this.enablement);
                if (extendedMode != null && LocationModeManager.this.enablement.isAvailable(dockable, extendedMode)) {
                    LocationModeManager.this.setMode(dockable, extendedMode);
                    LocationModeManager.this.ensureValidLocation(dockable);
                    return true;
                }
            }
            return false;
        }
    };
    private ExtendedModeEnablement enablement;
    private int layoutMode = 0;

    public LocationModeManager(DockController dockController) {
        super(dockController);
        this.registerListener.connect(dockController);
        dockController.getRelocator().addDockRelocatorListener(this.relocatorListener);
        this.updateEnablement();
        this.extendedModeFactory.setProperties(dockController);
        this.addModeManagerListener(new LocationModeListenerAdapter());
        dockController.getDoubleClickController().addListener(this.doubleClickListener);
    }

    @Override
    public void destroy() {
        this.registerListener.connect(null);
        DockController dockController = this.getController();
        dockController.getRelocator().removeDockRelocatorListener(this.relocatorListener);
        dockController.getDoubleClickController().removeListener(this.doubleClickListener);
        for (LocationMode locationMode : this.modes()) {
            locationMode.setController(null);
        }
        super.destroy();
        this.extendedModeFactory.setProperties((DockProperties)null);
    }

    protected void updateEnablement() {
        if (this.enablement != null) {
            this.enablement.destroy();
            this.enablement = null;
        }
        if (this.getController() != null) {
            this.enablement = this.extendedModeFactory.getValue().create(this);
        }
        this.rebuildAll();
    }

    public void setMode(Dockable dockable, ExtendedMode extendedMode) {
        LocationMode locationMode = (LocationMode)this.getMode(extendedMode.getModeIdentifier());
        if (locationMode == null) {
            throw new IllegalArgumentException("No mode '" + extendedMode.getModeIdentifier() + "' available");
        }
        this.apply(dockable, locationMode, false);
    }

    public ExtendedMode getMode(Dockable dockable) {
        Mode mode = this.getCurrentMode(dockable);
        if (mode == null) {
            return null;
        }
        return mode.getExtendedMode();
    }

    public Map<ExtendedMode, DockStation> getRepresentations(String string) {
        if (string == null) {
            throw new IllegalArgumentException("id must not be null");
        }
        HashMap<ExtendedMode, DockStation> hashMap = new HashMap<ExtendedMode, DockStation>();
        for (LocationMode locationMode : this.modes()) {
            DockStation dockStation = locationMode.getRepresentation(string);
            if (dockStation == null) continue;
            hashMap.put(locationMode.getExtendedMode(), dockStation);
        }
        return hashMap;
    }

    @Override
    protected void applyDuringRead(String string, Path path, Path path2, Dockable dockable) {
    }

    public boolean isModeAvailable(Dockable dockable, ExtendedMode extendedMode) {
        if (this.enablement == null) {
            return false;
        }
        return this.enablement.isAvailable(dockable, extendedMode);
    }

    public void addListener(Path path, LocationModeListener locationModeListener) {
        if (locationModeListener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        List<LocationModeListener> list = this.listeners.get(path);
        if (list == null) {
            list = new ArrayList<LocationModeListener>();
            this.listeners.put(path, list);
        }
        list.add(locationModeListener);
        LocationMode locationMode = (LocationMode)this.getMode(path);
        if (locationMode != null) {
            locationMode.addLocationModeListener(locationModeListener);
        }
    }

    public void removeListener(Path path, LocationModeListener locationModeListener) {
        LocationMode locationMode;
        List<LocationModeListener> list = this.listeners.get(path);
        if (list == null) {
            return;
        }
        list.remove(locationModeListener);
        if (list.isEmpty()) {
            this.listeners.remove(path);
        }
        if ((locationMode = (LocationMode)this.getMode(path)) != null) {
            locationMode.removeLocationModeListener(locationModeListener);
        }
    }

    @Override
    public M getCurrentMode(Dockable dockable) {
        while (dockable != null) {
            for (LocationMode locationMode : this.modes()) {
                if (!locationMode.isCurrentMode(dockable)) continue;
                return (M)locationMode;
            }
            DockStation dockStation = dockable.getDockParent();
            dockable = dockStation == null ? null : dockStation.asDockable();
        }
        return null;
    }

    public DoubleClickLocationStrategy getDoubleClickStrategy() {
        return this.doubleClickStrategy.getValue();
    }

    public void setDoubleClickStrategy(DoubleClickLocationStrategy doubleClickLocationStrategy) {
        this.doubleClickStrategy.setValue(doubleClickLocationStrategy);
    }

    public boolean isLayouting() {
        return this.layoutMode > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runLayoutTransaction(Runnable runnable) {
        try {
            ++this.layoutMode;
            this.runTransaction(runnable, true);
        }
        finally {
            --this.layoutMode;
        }
    }

    public void ensureNotHidden(final Dockable dockable) {
        if (this.isLayouting()) {
            return;
        }
        this.runTransaction(new Runnable(){

            public void run() {
                for (LocationMode locationMode : LocationModeManager.this.modes()) {
                    locationMode.ensureNotHidden(dockable);
                }
            }
        });
    }

    public void ensureValidLocation(Dockable dockable) {
    }

    private class RelocatorListener
    extends DockRelocatorAdapter {
        private RelocatorListener() {
        }

        public void drag(DockController dockController, Dockable dockable, DockStation dockStation) {
            LocationModeManager.this.store(dockable);
        }
    }

    private class HierarchyListener
    implements DockHierarchyListener {
        private HierarchyListener() {
        }

        public void controllerChanged(DockHierarchyEvent dockHierarchyEvent) {
        }

        public void hierarchyChanged(DockHierarchyEvent dockHierarchyEvent) {
            if (!LocationModeManager.this.isOnTransaction()) {
                LocationModeManager.this.refresh(dockHierarchyEvent.getDockable(), true);
            }
        }
    }

    private class RegisterListener
    extends DockRegisterAdapter {
        private DockController controller;

        private RegisterListener() {
        }

        public void connect(DockController dockController) {
            DockRegister dockRegister;
            if (this.controller != null) {
                dockRegister = this.controller.getRegister();
                dockRegister.removeDockRegisterListener(this);
                for (Dockable dockable : dockRegister.listDockables()) {
                    dockable.removeDockHierarchyListener(LocationModeManager.this.hierarchyListener);
                    LocationModeManager.this.rebuild(dockable);
                }
            }
            this.controller = dockController;
            if (dockController != null) {
                dockRegister = dockController.getRegister();
                dockRegister.addDockRegisterListener(this);
                for (Dockable dockable : dockRegister.listDockables()) {
                    dockable.addDockHierarchyListener(LocationModeManager.this.hierarchyListener);
                }
            }
        }

        public void dockableRegistered(DockController dockController, Dockable dockable) {
            dockable.addDockHierarchyListener(LocationModeManager.this.hierarchyListener);
            LocationModeManager.this.rebuild(dockable);
        }

        public void dockableUnregistered(DockController dockController, Dockable dockable) {
            dockable.removeDockHierarchyListener(LocationModeManager.this.hierarchyListener);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LocationModeListenerAdapter
    implements ModeManagerListener<Location, LocationMode> {
        private LocationModeListenerAdapter() {
        }

        @Override
        public void modeAdded(ModeManager<? extends Location, ? extends LocationMode> modeManager, LocationMode locationMode) {
            locationMode.setManager(LocationModeManager.this);
            locationMode.setController(LocationModeManager.this.getController());
            List list = (List)LocationModeManager.this.listeners.get(locationMode.getUniqueIdentifier());
            if (list != null) {
                for (LocationModeListener locationModeListener : list) {
                    locationMode.addLocationModeListener(locationModeListener);
                }
            }
        }

        @Override
        public void modeRemoved(ModeManager<? extends Location, ? extends LocationMode> modeManager, LocationMode locationMode) {
            locationMode.setManager(null);
            locationMode.setController(null);
            List list = (List)LocationModeManager.this.listeners.get(locationMode.getUniqueIdentifier());
            if (list != null) {
                for (LocationModeListener locationModeListener : list) {
                    locationMode.removeLocationModeListener(locationModeListener);
                }
            }
        }

        @Override
        public void dockableAdded(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable) {
        }

        @Override
        public void dockableRemoved(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable) {
        }

        @Override
        public void modeChanged(ModeManager<? extends Location, ? extends LocationMode> modeManager, Dockable dockable, LocationMode locationMode, LocationMode locationMode2) {
        }
    }
}

