/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.station.split;

import bibliothek.gui.dock.facile.station.split.ConflictResolver;
import bibliothek.gui.dock.facile.station.split.ResizeNode;
import bibliothek.gui.dock.facile.station.split.ResizeRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConflictResolver<T>
implements ConflictResolver<T> {
    private int increment(int n) {
        return n == -1 ? -1 : n + 1;
    }

    @Override
    public ResizeRequest requestHorizontal(ResizeRequest resizeRequest, ResizeRequest resizeRequest2, ResizeNode<T> resizeNode) {
        if (resizeRequest == null && resizeRequest2 == null) {
            return null;
        }
        if (resizeRequest == null) {
            return new ResizeRequest(resizeRequest2.getDeltaWidth(), resizeRequest2.getDeltaHeight(), this.increment(resizeRequest2.getFractionWidth()), resizeRequest2.getFractionHeight());
        }
        if (resizeRequest2 == null) {
            return new ResizeRequest(resizeRequest.getDeltaWidth(), resizeRequest.getDeltaHeight(), this.increment(resizeRequest.getFractionWidth()), resizeRequest.getFractionHeight());
        }
        double d = 0.0;
        int n = -1;
        if (resizeRequest.getFractionWidth() == -1 && resizeRequest2.getFractionWidth() == -1) {
            d = 0.0;
            n = -1;
        } else if (resizeRequest.getFractionWidth() == -1) {
            d = resizeRequest2.getDeltaWidth();
            n = resizeRequest2.getFractionWidth() + 1;
        } else if (resizeRequest2.getFractionWidth() == -1) {
            d = resizeRequest.getDeltaWidth();
            n = resizeRequest.getFractionWidth() + 1;
        } else {
            d = resizeRequest.getDeltaWidth() / (double)resizeRequest.getFractionWidth() + resizeRequest2.getDeltaWidth() / (double)resizeRequest2.getFractionWidth() + resizeNode.getNewDividerSize() - resizeNode.getOldDividerSize();
            n = 1;
        }
        double d2 = 0.0;
        int n2 = -1;
        if (resizeRequest.getFractionHeight() == -1 && resizeRequest2.getFractionHeight() == -1) {
            d2 = 0.0;
            n2 = -1;
        } else if (resizeRequest.getFractionHeight() == -1) {
            d2 = resizeRequest2.getDeltaHeight();
            n2 = resizeRequest2.getFractionHeight();
        } else if (resizeRequest2.getFractionHeight() == -1) {
            d2 = resizeRequest.getDeltaHeight();
            n2 = resizeRequest.getFractionHeight();
        } else if (resizeRequest.getFractionHeight() == resizeRequest2.getFractionHeight()) {
            d2 = (resizeRequest.getDeltaHeight() + resizeRequest2.getDeltaHeight()) / 2.0;
            n2 = resizeRequest.getFractionHeight();
        } else if (resizeRequest.getFractionHeight() < resizeRequest2.getFractionHeight()) {
            d2 = resizeRequest.getDeltaHeight();
            n2 = resizeRequest.getFractionHeight();
        } else {
            d2 = resizeRequest2.getDeltaHeight();
            n2 = resizeRequest2.getFractionHeight();
        }
        if (n == -1 && n2 == -1) {
            return null;
        }
        return new ResizeRequest(d, d2, n, n2);
    }

    @Override
    public ResizeRequest requestVertical(ResizeRequest resizeRequest, ResizeRequest resizeRequest2, ResizeNode<T> resizeNode) {
        if (resizeRequest == null && resizeRequest2 == null) {
            return null;
        }
        if (resizeRequest == null) {
            return new ResizeRequest(resizeRequest2.getDeltaWidth(), resizeRequest2.getDeltaHeight(), resizeRequest2.getFractionWidth(), this.increment(resizeRequest2.getFractionHeight()));
        }
        if (resizeRequest2 == null) {
            return new ResizeRequest(resizeRequest.getDeltaWidth(), resizeRequest.getDeltaHeight(), resizeRequest.getFractionWidth(), this.increment(resizeRequest.getFractionHeight()));
        }
        double d = 0.0;
        int n = -1;
        if (resizeRequest.getFractionWidth() == -1 && resizeRequest2.getFractionWidth() == -1) {
            d = 0.0;
            n = -1;
        } else if (resizeRequest.getFractionWidth() == -1) {
            d = resizeRequest2.getDeltaWidth();
            n = resizeRequest2.getFractionWidth();
        } else if (resizeRequest2.getFractionWidth() == -1) {
            d = resizeRequest.getDeltaWidth();
            n = resizeRequest.getFractionWidth();
        } else if (resizeRequest.getFractionWidth() == resizeRequest2.getFractionWidth()) {
            d = (resizeRequest.getDeltaWidth() + resizeRequest2.getDeltaWidth()) / 2.0;
            n = resizeRequest.getFractionWidth();
        } else if (resizeRequest.getFractionWidth() < resizeRequest2.getFractionWidth()) {
            d = resizeRequest.getDeltaWidth();
            n = resizeRequest.getFractionWidth();
        } else {
            d = resizeRequest2.getDeltaWidth();
            n = resizeRequest2.getFractionWidth();
        }
        double d2 = 0.0;
        int n2 = -1;
        if (resizeRequest.getFractionHeight() == -1 && resizeRequest2.getFractionHeight() == -1) {
            d2 = 0.0;
            n2 = -1;
        } else if (resizeRequest.getFractionHeight() == -1) {
            d2 = resizeRequest2.getDeltaHeight();
            n2 = resizeRequest2.getFractionHeight() + 1;
        } else if (resizeRequest2.getFractionHeight() == -1) {
            d2 = resizeRequest.getDeltaHeight();
            n2 = resizeRequest.getFractionHeight() + 1;
        } else {
            d2 = resizeRequest.getDeltaHeight() / (double)resizeRequest.getFractionHeight() + resizeRequest2.getDeltaHeight() / (double)resizeRequest2.getFractionHeight() + resizeNode.getNewDividerSize() - resizeNode.getOldDividerSize();
            n2 = 1;
        }
        if (n == -1 && n2 == -1) {
            return null;
        }
        return new ResizeRequest(d, d2, n, n2);
    }

    @Override
    public double resolveHorizontal(ResizeNode<T> resizeNode, ResizeRequest resizeRequest, double d, ResizeRequest resizeRequest2, double d2) {
        if (resizeRequest.getFractionWidth() == 1 && resizeRequest2.getFractionWidth() > 1) {
            return d;
        }
        if (resizeRequest.getFractionWidth() > 1 && resizeRequest2.getFractionWidth() == 1) {
            return d2;
        }
        return (d * (double)resizeRequest.getFractionWidth() + d2 * (double)resizeRequest2.getFractionWidth()) / (double)(resizeRequest.getFractionWidth() + resizeRequest2.getFractionWidth());
    }

    @Override
    public double resolveVertical(ResizeNode<T> resizeNode, ResizeRequest resizeRequest, double d, ResizeRequest resizeRequest2, double d2) {
        if (resizeRequest.getFractionHeight() == 1 && resizeRequest2.getFractionHeight() > 1) {
            return d;
        }
        if (resizeRequest.getFractionHeight() > 1 && resizeRequest2.getFractionHeight() == 1) {
            return d2;
        }
        return (d * (double)resizeRequest.getFractionHeight() + d2 * (double)resizeRequest2.getFractionHeight()) / (double)(resizeRequest.getFractionHeight() + resizeRequest2.getFractionHeight());
    }
}

