/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.menu;

import bibliothek.gui.dock.support.menu.MenuPiece;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseMenuPiece
extends MenuPiece {
    private List<Component> items = new ArrayList<Component>();

    @Override
    public void fill(List<Component> list) {
        list.addAll(this.items);
    }

    @Override
    public int getItemCount() {
        return this.items.size();
    }

    protected Component getItem(int n) {
        return this.items.get(n);
    }

    protected void addSeparator() {
        this.insertSeparator(this.getItemCount());
    }

    protected void insertSeparator(int n) {
        this.insert(n, new JPopupMenu.Separator());
    }

    protected void insert(int n, Component component) {
        this.items.add(n, component);
        this.fireInsert(n, component);
    }

    protected void add(Component component) {
        this.insert(this.getItemCount(), component);
    }

    protected void remove(Component component) {
        int n = this.items.indexOf(component);
        if (n >= 0) {
            this.remove(n);
        }
    }

    protected void remove(int n) {
        this.items.remove(n);
        this.fireRemove(n, 1);
    }

    protected void removeAll() {
        int n = this.items.size();
        this.items.clear();
        this.fireRemove(0, n);
    }
}

