/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern.color;

import bibliothek.gui.dock.common.ColorMap;
import bibliothek.gui.dock.common.event.ColorMapListener;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.ui.UITransmitter;
import bibliothek.gui.dock.util.color.ColorBridge;
import bibliothek.gui.dock.util.color.DockColor;
import java.awt.Color;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ColorTransmitter
extends UITransmitter<Color, DockColor>
implements ColorBridge {
    private Listener listener = new Listener();

    public ColorTransmitter(String ... keys) {
        super(keys);
    }

    protected Color getFirstNonNull(ColorMap map, String ... keys) {
        for (String key : keys) {
            Color color = map.getColor(key);
            if (color == null) continue;
            return color;
        }
        return null;
    }

    @Override
    protected void connect(CDockable dockable) {
        dockable.getColors().addListener(this.listener);
    }

    @Override
    protected void disconnect(CDockable dockable) {
        dockable.getColors().removeListener(this.listener);
    }

    private class Listener
    implements ColorMapListener {
        private Listener() {
        }

        public void colorChanged(ColorMap map, String key, Color color) {
            ColorTransmitter.this.update(map.getDockable(), key, color);
        }
    }
}

